/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductAwareMojo;
import com.atlassian.maven.plugins.amps.Application;
import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.Node;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AmpsDefaults;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.util.ArtifactRetriever;
import com.atlassian.maven.plugins.amps.util.ProductHandlerUtil;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractProductHandlerMojo
extends AbstractProductAwareMojo {
    protected static final String ATLASSIAN_TEST_RUNNER_VERSION = "2.0.2";
    protected static final String NO_TEST_GROUP = "__no_test_group__";
    private static final String JUNIT_GROUP_ID = "org.apache.servicemix.bundles";
    private static final String JUNIT_ARTIFACT_ID = "org.apache.servicemix.bundles.junit";
    private static final String JUNIT_VERSION = "4.12_1";
    private static final String TESTRUNNER_GROUP_ID = "com.atlassian.plugins";
    private static final String TESTRUNNER_ARTIFACT_ID = "atlassian-plugins-osgi-testrunner";
    private static final String TESTRUNNER_BUNDLE_ARTIFACT_ID = "atlassian-plugins-osgi-testrunner-bundle";
    public static final String DEFAULT_HTTPS_KEYSTOREFILE = "${user.home}/.keystore";
    public static final String DEFAULT_HTTPS_KEYSTOREPASS = "changeit";
    public static final String DEFAULT_HTTPS_KEYALIAS = "tomcat";
    public static final String DEFAULT_HTTP_SECURE = "true";
    public static final String DEFAULT_HTTPS_SSL_PROTOCOL = "TLS";
    public static final String DEFAULT_HTTPS_CLIENTAUTH = "false";
    public static final String DEFAULT_HTTPS_PORT = "0";
    @Component
    private RepositoryMetadataManager repositoryMetadataManager;
    private final List<ProductArtifact> testFrameworkPlugins = new ArrayList<ProductArtifact>();
    @Parameter(property="container")
    private String containerId;
    @Parameter(property="customContainerArtifact")
    private String customContainerArtifact;
    @Parameter(property="http.port", defaultValue="0")
    private int httpPort;
    @Parameter(property="ajp.port", defaultValue="8009")
    private int ajpPort;
    @Parameter(property="use.https", defaultValue="false")
    private boolean useHttps;
    @Parameter(property="https.port", defaultValue="0")
    private int httpsPort;
    @Parameter(property="https.clientAuth", defaultValue="false")
    private String httpsClientAuth;
    @Parameter(property="https.sslProtocol", defaultValue="TLS")
    private String httpsSslProtocol;
    @Parameter(property="https.keystoreFile", defaultValue="${user.home}/.keystore")
    private String httpsKeystoreFile;
    @Parameter(property="https.keystorePass", defaultValue="changeit")
    private String httpsKeystorePass;
    @Parameter(property="https.keyAlias", defaultValue="tomcat")
    private String httpsKeyAlias;
    @Parameter(property="https.httpSecure", defaultValue="true")
    private boolean httpsHttpSecure;
    @Parameter(property="context.path")
    protected String contextPath;
    @Parameter(property="server")
    protected String server;
    @Parameter(property="product.version")
    private String productVersion;
    @Parameter(property="jvmargs")
    protected String jvmArgs;
    @Parameter(property="product.start.timeout")
    private int startupTimeout;
    @Parameter(property="product.stop.timeout")
    private int shutdownTimeout;
    @Deprecated
    @Parameter
    protected Properties systemProperties = new Properties();
    @Parameter
    protected Map<String, Object> systemPropertyVariables = new HashMap<String, Object>();
    @Parameter
    private File log4jProperties;
    @Parameter
    private File log4j2Config;
    @Deprecated
    @Parameter(property="test.resources.version")
    private String testResourcesVersion;
    @Parameter(property="product.data.version")
    private String productDataVersion;
    @Parameter(property="product.data.path")
    private String productDataPath;
    @Parameter(property="product.data.overrides.path")
    private String productDataOverridesPath;
    @Parameter(property="devtoolbox.enable", defaultValue="true")
    private boolean enableDevToolbox;
    @Parameter(property="devtoolbox.version", defaultValue="3.0.1")
    private String devToolboxVersion;
    @Parameter(property="quickreload.enable", defaultValue="false")
    private boolean enableQuickReload;
    @Parameter(property="quickreload.version", defaultValue="3.1.0")
    private String quickReloadVersion;
    @Parameter(property="viewer.enable", defaultValue="false")
    private boolean enablePluginViewer;
    @Parameter(property="viewer.version", defaultValue="1.0.4")
    private String pluginViewerVersion;
    @Parameter(property="pde.enable", defaultValue="true")
    private boolean enablePde;
    @Parameter(property="pde.version", defaultValue="1.2")
    private String pdeVersion;
    @Parameter
    private List<Application> applications = new ArrayList<Application>();
    @Parameter
    private List<ProductArtifact> pluginArtifacts = new ArrayList<ProductArtifact>();
    @Parameter
    private List<ProductArtifact> libArtifacts = new ArrayList<ProductArtifact>();
    @Parameter
    private List<ProductArtifact> bundledArtifacts = new ArrayList<ProductArtifact>();
    @Deprecated
    @Parameter
    private String salVersion;
    @Deprecated
    @Parameter(defaultValue="0.6")
    private String pdkVersion;
    @Deprecated
    @Parameter
    private String restVersion;
    @Deprecated
    @Parameter(defaultValue="1.2.8")
    private String webConsoleVersion;
    @Parameter
    private DataSource dataSource;
    @Parameter
    private List<Node> nodes;
    @Parameter(property="plugins")
    private String pluginArtifactsString;
    @Parameter(property="lib.plugins")
    private String libArtifactsString;
    @Parameter(property="bundled.plugins")
    private String bundledArtifactsString;
    @Parameter(property="project.build.directory", required=true)
    protected File targetDirectory;
    @Parameter(property="project.build.finalName", required=true)
    protected String finalName;
    @Parameter(property="install.plugin", defaultValue="true")
    protected boolean installPlugin;
    @Parameter(property="localRepository")
    private ArtifactRepository localRepository;
    @Parameter(property="project.remoteArtifactRepositories")
    private List<ArtifactRepository> repositories;
    @Parameter
    private List<Product> products = new ArrayList<Product>();
    private Map<String, Product> productMap;
    @Parameter
    private String output;
    @Parameter(property="additional.resource.folders")
    private String additionalResourceFolders;
    @Parameter(property="parallel", defaultValue="false")
    protected boolean parallel;
    @Parameter(property="await.full.initialization", defaultValue="true")
    private boolean awaitFullInitialization;
    @Parameter(property="product.license")
    private String productLicense;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.pluginArtifacts.addAll(ProductHandlerUtil.toArtifacts(this.pluginArtifactsString));
        this.libArtifacts.addAll(ProductHandlerUtil.toArtifacts(this.libArtifactsString));
        this.bundledArtifacts.addAll(ProductHandlerUtil.toArtifacts(this.bundledArtifactsString));
        this.systemPropertyVariables.putAll(this.systemProperties);
        this.doExecute();
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    private Product createDefaultProductContext() throws MojoExecutionException {
        Product product = new Product();
        product.setId(this.getProductId());
        product.setCustomContainerArtifact(this.customContainerArtifact);
        product.setContainerId(this.containerId);
        product.setServer(this.server);
        product.setContextPath(this.contextPath);
        product.setJvmArgs(this.jvmArgs);
        product.setStartupTimeout(this.startupTimeout);
        product.setShutdownTimeout(this.shutdownTimeout);
        product.setNodes(this.nodes);
        HashMap<String, Object> properties = new HashMap<String, Object>(this.systemPropertyVariables);
        properties.put("atlassian.sdk.version", this.getAmpsPluginVersion());
        AbstractProductHandlerMojo.putDefaultedSystemProperty(properties, "atlassian.dev.mode", DEFAULT_HTTP_SECURE);
        AbstractProductHandlerMojo.putDefaultedSystemProperty(properties, "atlassian.allow.insecure.url.parameter.login", DEFAULT_HTTP_SECURE);
        AbstractProductHandlerMojo.putDefaultedSystemProperty(properties, "java.awt.headless", DEFAULT_HTTP_SECURE);
        AbstractProductHandlerMojo.putDefaultedSystemProperty(properties, "plugin.resource.directories", this.getResourceDirs());
        AbstractProductHandlerMojo.putDefaultedSystemProperty(properties, "plugin.root.directories", this.buildRootProperty());
        product.setSystemPropertyVariables(properties);
        product.setBundledArtifacts(this.bundledArtifacts);
        product.setLibArtifacts(this.libArtifacts);
        product.setApplications(this.applications);
        product.setPluginArtifacts(this.pluginArtifacts);
        product.setLog4jProperties(this.log4jProperties);
        product.setLog4j2Config(this.log4j2Config);
        product.setHttpPort(this.httpPort);
        product.setAjpPort(this.ajpPort);
        product.setUseHttps(this.useHttps);
        product.setHttpsPort(this.httpsPort);
        product.setHttpsClientAuth(this.httpsClientAuth);
        product.setHttpsSSLProtocol(this.httpsSslProtocol);
        product.setHttpsKeystoreFile(this.httpsKeystoreFile);
        product.setHttpsKeystorePass(this.httpsKeystorePass);
        product.setHttpsKeyAlias(this.httpsKeyAlias);
        product.setHttpsHttpSecure(this.httpsHttpSecure);
        product.setVersion(this.productVersion);
        product.setDataVersion(this.productDataVersion);
        product.setDataPath(this.productDataPath);
        product.setDataOverridesPath(this.productDataOverridesPath);
        product.setLicense(this.productLicense);
        product.setRestVersion(this.restVersion);
        product.setSalVersion(this.salVersion);
        product.setAwaitFullInitialization(this.awaitFullInitialization);
        product.setDevToolboxVersion(this.devToolboxVersion);
        product.setEnableDevToolbox(this.enableDevToolbox);
        product.setEnablePde(this.enablePde);
        product.setEnablePluginViewer(this.enablePluginViewer);
        product.setEnableQuickReload(this.enableQuickReload);
        product.setPdeVersion(this.pdeVersion);
        product.setPdkVersion(this.pdkVersion);
        product.setPluginViewerVersion(this.pluginViewerVersion);
        product.setQuickReloadVersion(this.quickReloadVersion);
        product.setWebConsoleVersion(this.webConsoleVersion);
        if (this.dataSource != null) {
            product.setDataSources(Collections.singletonList(this.dataSource));
        }
        return product;
    }

    private String getResourceDirs() {
        String[] additionalResourceDirs;
        ArrayList<String> resourceDirs = new ArrayList<String>();
        for (String string : additionalResourceDirs = StringUtils.split((String)StringUtils.trimToEmpty((String)this.additionalResourceFolders), (String)",")) {
            File dir = new File(string);
            if (!dir.exists()) continue;
            resourceDirs.add(StringUtils.trim((String)string));
        }
        MavenProject mavenProject = this.getMavenContext().getProject();
        for (Resource resource : mavenProject.getResources()) {
            File file = new File(resource.getDirectory());
            if (!file.exists()) continue;
            resourceDirs.add(resource.getDirectory());
        }
        if (ProjectUtils.shouldDeployTestJar(this.getMavenContext())) {
            for (Resource resource : mavenProject.getTestResources()) {
                resourceDirs.add(resource.getDirectory());
            }
        }
        return String.join((CharSequence)",", resourceDirs);
    }

    private String buildRootProperty() {
        return Optional.of(this.getMavenContext()).map(MavenContext::getProject).map(MavenProject::getBasedir).map(File::getPath).orElse("");
    }

    private static void putDefaultedSystemProperty(Map<String, Object> map, String key, String defaultValue) {
        map.computeIfAbsent(key, k -> System.getProperty(k, defaultValue));
    }

    private void setDefaultValues(Product product) {
        ProductHandler handler = this.getProductHandler(product.getId());
        product.setDataVersion(System.getProperty("product.data.version", product.getDataVersion()));
        product.setVersion(System.getProperty("product.version", product.getVersion()));
        product.setDataPath(System.getProperty("product.data.path", product.getDataPath()));
        product.setInstanceId(AbstractProductHandlerMojo.getProductInstanceId(product));
        product.setArtifactRetriever(new ArtifactRetriever(this.artifactResolver, this.repositorySystem, this.localRepository, this.repositories, this.repositoryMetadataManager));
        if (AbstractProductHandlerMojo.containerIdNotDefinedOrProductSpecific(product)) {
            try {
                product.setContainerId(handler.getDefaultContainerId(product));
            }
            catch (MojoExecutionException e) {
                product.setContainerId(handler.getDefaultContainerId());
            }
            product.setContainerNotSpecified(true);
        }
        if (product.getServer() == null) {
            product.setServer(AmpsDefaults.DEFAULT_SERVER);
        }
        if (product.getPdkVersion() == null) {
            product.setPdkVersion("0.6");
        }
        if (product.getWebConsoleVersion() == null) {
            product.setWebConsoleVersion("1.2.8");
        }
        if (product.isEnableDevToolbox() == null) {
            product.setEnableDevToolbox(true);
        }
        if (product.getDevToolboxVersion() == null) {
            product.setDevToolboxVersion("3.0.1");
        }
        if (product.isEnableQuickReload() == null) {
            product.setEnableQuickReload(false);
        }
        if (product.getQuickReloadVersion() == null) {
            product.setQuickReloadVersion("3.1.0");
        }
        if (product.isEnablePluginViewer() == null) {
            product.setEnablePluginViewer(false);
        }
        if (product.getPluginViewerVersion() == null) {
            product.setPluginViewerVersion("1.0.4");
        }
        if (product.getPdeVersion() == null) {
            product.setPdeVersion("1.2");
        }
        if (product.getOutput() == null) {
            product.setOutput(this.output);
        }
        if (product.getStartupTimeout() <= 0) {
            product.setStartupTimeout(600000);
        }
        if (product.getShutdownTimeout() <= 0) {
            product.setShutdownTimeout(600000);
        }
        if (product.getHttpPort() == 0) {
            product.setHttpPort(handler.getDefaultHttpPort());
        }
        if (product.getUseHttps() == null) {
            product.setUseHttps(false);
        }
        if (product.getHttpsPort() == 0) {
            product.setHttpsPort(handler.getDefaultHttpsPort());
        }
        if (product.getHttpsClientAuth() == null) {
            product.setHttpsClientAuth(DEFAULT_HTTPS_CLIENTAUTH);
        }
        if (product.getHttpsSSLProtocol() == null) {
            product.setHttpsSSLProtocol(DEFAULT_HTTPS_SSL_PROTOCOL);
        }
        if (product.getHttpsKeystoreFile() == null) {
            product.setHttpsKeystoreFile(DEFAULT_HTTPS_KEYSTOREFILE);
        }
        if (product.getHttpsKeystorePass() == null) {
            product.setHttpsKeystorePass(DEFAULT_HTTPS_KEYSTOREPASS);
        }
        if (product.getHttpsKeyAlias() == null) {
            product.setHttpsKeyAlias(DEFAULT_HTTPS_KEYALIAS);
        }
        if (product.getHttpsHttpSecure() == null) {
            product.setHttpsHttpSecure(Boolean.parseBoolean(DEFAULT_HTTP_SECURE));
        }
        if (product.getVersion() == null) {
            product.setVersion("RELEASE");
        }
        if (product.getDataVersion() == null) {
            product.setDataVersion(product.getVersion());
        }
        if (product.getContextPath() == null) {
            product.setContextPath(handler.getDefaultContextPath());
        }
        if (product.getDataSources() == null) {
            product.setDataSources(new ArrayList<DataSource>());
        }
        product.initialiseNodes();
    }

    private static boolean containerIdNotDefinedOrProductSpecific(Product product) {
        return product.getContainerId() == null || AbstractProductHandlerMojo.isProductSpecificContainerId(product);
    }

    private static boolean isProductSpecificContainerId(Product product) {
        return "productSpecific".toUpperCase(Locale.ENGLISH).equals(product.getContainerId().toUpperCase(Locale.ENGLISH));
    }

    @Nonnull
    public final List<ProductArtifact> getTestFrameworkPlugins() {
        if (this.testFrameworkPlugins.isEmpty()) {
            String jUnitVersion = this.getMavenContext().getVersionOverrides().getProperty(JUNIT_ARTIFACT_ID, JUNIT_VERSION);
            this.testFrameworkPlugins.add(new ProductArtifact(JUNIT_GROUP_ID, JUNIT_ARTIFACT_ID, jUnitVersion));
            this.testFrameworkPlugins.add(new ProductArtifact(TESTRUNNER_GROUP_ID, TESTRUNNER_BUNDLE_ARTIFACT_ID, this.getTestRunnerVersion()));
        }
        return Collections.unmodifiableList(this.testFrameworkPlugins);
    }

    private String getTestRunnerVersion() {
        MavenContext mavenContext = this.getMavenContext();
        Properties overrides = mavenContext.getVersionOverrides();
        Artifact testRunnerDependency = ProjectUtils.getReactorArtifact(mavenContext, TESTRUNNER_GROUP_ID, TESTRUNNER_ARTIFACT_ID);
        String testRunnerVersion = Optional.ofNullable(testRunnerDependency).map(Artifact::getVersion).orElse(ATLASSIAN_TEST_RUNNER_VERSION);
        return overrides.getProperty(TESTRUNNER_BUNDLE_ARTIFACT_ID, testRunnerVersion);
    }

    private Map<String, Product> createProductContexts() throws MojoExecutionException {
        HashMap<String, Product> productContexts = new HashMap<String, Product>();
        this.makeProductsInheritDefaultConfiguration(this.products, productContexts);
        productContexts.values().forEach(this::setDefaultValues);
        return productContexts;
    }

    protected final Map<String, Product> getProductContexts() throws MojoExecutionException {
        if (this.productMap == null) {
            this.productMap = this.createProductContexts();
        }
        return this.productMap;
    }

    @VisibleForTesting
    final void makeProductsInheritDefaultConfiguration(List<Product> products, Map<String, Product> productMap) throws MojoExecutionException {
        Product defaultProduct = this.createDefaultProductContext();
        productMap.put(this.getProductId(), defaultProduct);
        for (Product product : products) {
            Product processedProduct = product.merge(defaultProduct);
            String instanceId = AbstractProductHandlerMojo.getProductInstanceId(processedProduct);
            productMap.put(instanceId, processedProduct);
        }
    }

    private static String getProductInstanceId(Product processedProduct) {
        return processedProduct.getInstanceId() == null ? processedProduct.getId() : processedProduct.getInstanceId();
    }

    protected final void stopProducts(Collection<Product> products) throws MojoExecutionException {
        ExecutorService executor = Executors.newFixedThreadPool(products.size());
        try {
            long before = System.nanoTime();
            ArrayList<Product> reversed = new ArrayList<Product>(products);
            Collections.reverse(reversed);
            for (Product product : reversed) {
                this.shutDown(product, executor);
            }
            long after = System.nanoTime();
            this.getLog().info((CharSequence)("amps:stop in " + TimeUnit.NANOSECONDS.toSeconds(after - before) + "s"));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("Exception while stopping the products", (Exception)e);
        }
        if (this.parallel) {
            this.waitForProducts(products, false);
        }
    }

    private void shutDown(Product product, ExecutorService executor) throws InterruptedException, ExecutionException {
        Future<?> task = executor.submit(() -> {
            this.getLog().info((CharSequence)(product.getInstanceId() + ": Shutting down"));
            try {
                this.getProductHandler(product.getId()).stop(product);
            }
            catch (MojoExecutionException e) {
                this.getLog().error((CharSequence)("Exception while trying to stop " + product.getInstanceId()), (Throwable)e);
            }
        });
        try {
            task.get(product.getShutdownTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            this.getLog().info((CharSequence)(product.getInstanceId() + " shutdown: Didn't return in time"));
            task.cancel(true);
        }
    }

    protected final void waitForProducts(Collection<Product> products, boolean startingUp) throws MojoExecutionException {
        for (Product product : products) {
            for (Node node : product.getNodes()) {
                ProductHandlerUtil.awaitStateChange(product, node, startingUp, this.getLog());
            }
        }
    }

    protected final void setParallelMode(Collection<Product> products) {
        products.forEach(product -> product.setSynchronicity(this.parallel));
    }
}

