/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.updater;

import com.atlassian.maven.plugins.updater.SdkPackageType;
import com.atlassian.maven.plugins.updater.SdkResource;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class MarketplaceSdkResource
extends AbstractLogEnabled
implements SdkResource {
    private static final String SDK_DOWNLOAD_URL_ROOT = "https://marketplace.atlassian.com/rest/1.0/plugins/atlassian-plugin-sdk-";
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public File downloadLatestSdk(SdkPackageType packageType) {
        return this.downloadSdk(packageType, this.getLatestSdkVersion(packageType));
    }

    @Override
    public File downloadSdk(SdkPackageType packageType, String version) {
        File sdkDownloadTempFile;
        Map<?, ?> rootAsMap = this.getPluginJsonAsMap(packageType);
        String versionDownloadPath = null;
        Map versionsElement = (Map)rootAsMap.get("versions");
        List versions = (List)versionsElement.get("versions");
        block16: for (Map versionData : versions) {
            if (!versionData.get("version").equals(version)) continue;
            List links = (List)versionData.get("links");
            for (Map link : links) {
                if (!link.get("rel").equals("binary")) continue;
                versionDownloadPath = (String)link.get("href");
                continue block16;
            }
        }
        if (versionDownloadPath == null) {
            throw new RuntimeException("Couldn't find SDK version for " + packageType.key() + " on marketplace with version " + version);
        }
        HttpURLConnection conn = null;
        try {
            URL url;
            String tempFileSuffix = packageType == SdkPackageType.WINDOWS ? ".exe" : (packageType == SdkPackageType.MAC ? ".pkg" : (packageType == SdkPackageType.RPM ? ".rpm" : (packageType == SdkPackageType.DEB ? ".deb" : ".tar.gz")));
            sdkDownloadTempFile = File.createTempFile("atlassian-plugin-sdk-" + version, tempFileSuffix);
            try {
                url = new URL(versionDownloadPath);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            conn = (HttpURLConnection)url.openConnection();
            try (InputStream inputStream = conn.getInputStream();){
                this.copyResponseStreamToFile(inputStream, sdkDownloadTempFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return sdkDownloadTempFile;
    }

    @Override
    public String getLatestSdkVersion(SdkPackageType packageType) {
        Map<?, ?> rootAsMap = this.getPluginJsonAsMap(packageType);
        if (rootAsMap.containsKey("version")) {
            Map version = (Map)rootAsMap.get("version");
            return (String)version.get("version");
        }
        return "";
    }

    private void copyResponseStreamToFile(InputStream stream, File file) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            IOUtils.copy((InputStream)stream, (OutputStream)fos);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private Map<?, ?> getPluginJsonAsMap(SdkPackageType packageType) {
        String json;
        URL url;
        try {
            url = new URL(SDK_DOWNLOAD_URL_ROOT + packageType.key());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            try (BufferedInputStream jsonStream = new BufferedInputStream(conn.getInputStream());){
                json = IOUtils.toString((InputStream)jsonStream, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (UnknownHostException e) {
            this.getLogger().info("Unknown host " + url.getHost());
            json = "";
        }
        catch (ConnectException e) {
            this.getLogger().info("Fail to connect to host " + url.getHost());
            json = "";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return this.parseJsonToMap(json);
    }

    @VisibleForTesting
    Map<?, ?> parseJsonToMap(String json) {
        try {
            Object rootAsMap = StringUtils.isNotEmpty((CharSequence)json) ? (Map)this.mapper.readValue(json, Map.class) : ImmutableMap.of();
            return rootAsMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

