/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;

@ParametersAreNonnullByDefault
public class MavenProjectLoader {
    @Nonnull
    public Optional<MavenProject> loadMavenProject(MavenProject project, Artifact pomArtifact, ProjectBuilder projectBuilder) throws MojoExecutionException {
        try {
            ProjectBuildingRequest request = new DefaultProjectBuildingRequest(project.getProjectBuildingRequest()).setRemoteRepositories(project.getRemoteArtifactRepositories());
            return Optional.ofNullable(projectBuilder.build(pomArtifact, request).getProject());
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException(String.format("Could not build the MavenProject for %s", pomArtifact), (Exception)((Object)e));
        }
    }
}

