/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Node;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.XmlOverride;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractWebappProductHandler;
import com.atlassian.maven.plugins.amps.product.ConfluenceClusterConfigurer;
import com.atlassian.maven.plugins.amps.product.ConfluenceLicenseConfigurer;
import com.atlassian.maven.plugins.amps.product.JavaModulePackage;
import com.atlassian.maven.plugins.amps.product.manager.WebAppManager;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.atlassian.maven.plugins.amps.util.JvmArgsFix;
import com.atlassian.maven.plugins.amps.util.NetworkUtils;
import com.atlassian.maven.plugins.amps.util.ProductHandlerUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.repository.RepositorySystem;

public class ConfluenceProductHandler
extends AbstractWebappProductHandler {
    private static final Set<JavaModulePackage> EXTRA_ADD_OPENS = ImmutableSet.of((Object)new JavaModulePackage("java.base", "java.util.concurrent.atomic"), (Object)new JavaModulePackage("java.base", "java.util"));
    private static final Set<JavaModulePackage> EXTRA_ADD_EXPORTS = ImmutableSet.of((Object)new JavaModulePackage("java.base", "sun.security.action"), (Object)new JavaModulePackage("java.xml", "com.sun.org.apache.xml.internal.utils"));
    public static final String REQUIRE_SYNCHRONY_PROXY = "require.synchrony.proxy";
    public static final String SYNCHRONY_PROXY_VERSION = "synchrony.proxy.version";
    @VisibleForTesting
    static final String HAZELCAST_LISTEN_PORT = "confluence.cluster.hazelcast.listenPort";
    @VisibleForTesting
    static final String SYNCHRONY_PORT = "synchrony.port";
    private static final ProductArtifact CONFLUENCE_ARTIFACT = new ProductArtifact("com.atlassian.confluence", "confluence-webapp", "RELEASE");
    private static final ProductArtifact CONFLUENCE_TEST_RESOURCES_ARTIFACT = new ProductArtifact("com.atlassian.confluence.plugins", "confluence-plugin-test-resources");
    private static final ProductArtifact SYNCHRONY_PROXY = new ProductArtifact("com.atlassian.synchrony", "synchrony-proxy", "RELEASE", "war");
    private static final TreeMap<ComparableVersion, String> SYNCHRONY_PROXY_VERSIONS = new TreeMap();
    private static final String JPMS_ARGS_FILE = "WEB-INF/jpms-args.txt";

    public ConfluenceProductHandler(MavenContext context, MavenGoals goals, RepositorySystem repositorySystem, ArtifactResolver artifactResolver, WebAppManager webAppManager) {
        super(context, goals, new ConfluencePluginProvider(), repositorySystem, artifactResolver, webAppManager);
    }

    @Override
    @Nonnull
    public String getId() {
        return "confluence";
    }

    @Override
    protected boolean isStaticPlugin() {
        return false;
    }

    @Override
    protected void fixJvmArgs(Product product, File appDir) {
        File jpmsArgsFile = new File(appDir, JPMS_ARGS_FILE);
        if (jpmsArgsFile.isFile()) {
            this.log.info((CharSequence)("Using JPMS args file at " + jpmsArgsFile));
        }
        product.setJvmArgs(JvmArgsFix.empty().with("-Xmx", "4g").with("-Xms", "1g").withAddOpens(ADD_OPENS_FOR_TOMCAT).withAddOpens(ADD_OPENS_FOR_FELIX).withAddOpens(EXTRA_ADD_OPENS).withAddExports(EXTRA_ADD_EXPORTS).withArgsFile(jpmsArgsFile).apply(product.getJvmArgs()));
    }

    @Override
    @Nonnull
    public ProductArtifact getArtifact() {
        return CONFLUENCE_ARTIFACT;
    }

    @Override
    @Nonnull
    public Optional<ProductArtifact> getTestResourcesArtifact() {
        return Optional.of(CONFLUENCE_TEST_RESOURCES_ARTIFACT);
    }

    @Override
    public int getDefaultHttpPort() {
        return 1990;
    }

    @Override
    public int getDefaultHttpsPort() {
        return 8441;
    }

    @Override
    @Nonnull
    protected Map<String, String> getProductSpecificSystemProperties(Product product, int nodeIndex) {
        ImmutableMap.Builder systemProperties = ImmutableMap.builder();
        systemProperties.put((Object)"cargo.servlet.uriencoding", (Object)"UTF-8");
        if (product.isMultiNode()) {
            this.setHazelcastListenPort(product);
            systemProperties.put((Object)"confluence.allow.loopback.cluster", (Object)"true");
            systemProperties.put((Object)"confluence.cluster.node.name", (Object)(product.getInstanceId() + "-" + nodeIndex));
            this.setUpSynchrony(product, nodeIndex);
        }
        String homeDirectory = this.getHomeDirectories(product).get(nodeIndex).getPath();
        systemProperties.put((Object)"confluence.home", (Object)homeDirectory);
        return systemProperties.build();
    }

    private void setUpSynchrony(Product product, int nodeIndex) {
        Node node = product.getNodes().get(nodeIndex);
        if (nodeIndex == 0) {
            node.defaultSystemProperty(SYNCHRONY_PORT, () -> String.valueOf(ProductHandlerUtil.pickFreePort(0)));
        } else {
            node.setSystemProperty("synchrony.proxy.enabled", "false");
            String nodeZeroSynchronyPort = product.getNodes().get(0).getSystemProperties().get(SYNCHRONY_PORT);
            if (StringUtils.isBlank((CharSequence)nodeZeroSynchronyPort)) {
                throw new IllegalStateException(String.format("First node's Synchrony port is blank: '%s'", nodeZeroSynchronyPort));
            }
            String nodeZeroSynchronyUrl = String.format("http://localhost:%s/synchrony/v1", nodeZeroSynchronyPort);
            node.setSystemProperty("synchrony.service.url", nodeZeroSynchronyUrl);
        }
    }

    @Override
    protected boolean useBackdoorToInstallLicense() {
        return false;
    }

    private void setHazelcastListenPort(Product product) {
        product.defaultSystemProperty(HAZELCAST_LISTEN_PORT, () -> String.valueOf(ProductHandlerUtil.pickFreePort(0)));
    }

    @Override
    @Nonnull
    protected Optional<File> getUserInstalledPluginsDirectory(Product product, File webappDir, File homeDir) {
        return Optional.empty();
    }

    @Override
    @Nonnull
    protected List<ProductArtifact> getExtraProductDeployables(Product product) {
        return this.shouldDeploySynchronyProxy(product) ? Collections.singletonList(SYNCHRONY_PROXY) : Collections.emptyList();
    }

    private boolean shouldDeploySynchronyProxy(Product product) {
        boolean synchronyProxyRequired = true;
        if (StringUtils.isNotBlank((CharSequence)System.getProperty(REQUIRE_SYNCHRONY_PROXY))) {
            synchronyProxyRequired = Boolean.getBoolean(REQUIRE_SYNCHRONY_PROXY);
        }
        return synchronyProxyRequired && Character.getNumericValue(product.getVersion().charAt(0)) >= 6;
    }

    @Override
    protected void customiseInstance(Product product, File homeDir, File explodedWarDir) throws MojoExecutionException {
        product.setCargoXmlOverrides(this.serverXmlConfluenceOverride());
        if (this.shouldDeploySynchronyProxy(product)) {
            this.resolveSynchronyProxyVersion(product);
            this.installSynchronyProxy(product);
        }
        if (product.isMultiNode()) {
            this.configureCluster(homeDir, product);
        }
        if (product.hasUserConfiguredLicense()) {
            String license = product.getUserConfiguredLicense().orElseThrow(IllegalStateException::new);
            this.configureLicense(homeDir, license);
        }
    }

    private void configureLicense(File homeDir, String license) throws MojoExecutionException {
        Optional<File> confluenceConfigFile = ConfluenceProductHandler.getConfluenceConfigFile(homeDir);
        if (confluenceConfigFile.isPresent()) {
            new ConfluenceLicenseConfigurer().configure(confluenceConfigFile.get(), license);
        }
    }

    private void configureCluster(File homeDir, Product product) throws MojoExecutionException {
        Optional<File> confluenceConfigFile = ConfluenceProductHandler.getConfluenceConfigFile(homeDir);
        if (confluenceConfigFile.isPresent()) {
            File sharedHome = this.getSharedHome(product);
            new ConfluenceClusterConfigurer().configure(confluenceConfigFile.get(), sharedHome, NetworkUtils.getLoopbackInterface());
        }
    }

    private File getSharedHome(Product product) {
        if (StringUtils.isNotBlank((CharSequence)product.getSharedHome())) {
            return new File(product.getSharedHome());
        }
        return new File(this.getHomeDirectories(product).get(0), "shared-home");
    }

    private void resolveSynchronyProxyVersion(Product product) throws MojoExecutionException {
        this.log.debug((CharSequence)("Resolving synchrony proxy version for Confluence " + product.getVersion()));
        String synchronyProxyVersionProperty = System.getProperty(SYNCHRONY_PROXY_VERSION);
        if (StringUtils.isNotBlank((CharSequence)synchronyProxyVersionProperty)) {
            this.log.debug((CharSequence)("Synchrony proxy version is already set in system variable (to " + synchronyProxyVersionProperty + ")"));
            SYNCHRONY_PROXY.setVersion(synchronyProxyVersionProperty);
        } else {
            this.log.debug((CharSequence)"Synchrony proxy version is not set. Attempting to set corresponding version");
            Map.Entry<ComparableVersion, String> synchronyProxyVersion = SYNCHRONY_PROXY_VERSIONS.ceilingEntry(new ComparableVersion(product.getVersion()));
            if (synchronyProxyVersion != null) {
                SYNCHRONY_PROXY.setVersion(synchronyProxyVersion.getValue());
                this.log.debug((CharSequence)("Synchrony proxy version is set to " + synchronyProxyVersion.getValue()));
            }
        }
        if ("RELEASE".equals(SYNCHRONY_PROXY.getVersion()) || "LATEST".equals(SYNCHRONY_PROXY.getVersion())) {
            this.log.debug((CharSequence)"determining latest stable synchrony-proxy version...");
            Artifact warArtifact = this.repositorySystem.createProjectArtifact(SYNCHRONY_PROXY.getGroupId(), SYNCHRONY_PROXY.getArtifactId(), SYNCHRONY_PROXY.getVersion());
            String stableVersion = product.getArtifactRetriever().getLatestStableVersion(warArtifact);
            this.log.debug((CharSequence)("using latest stable synchrony-proxy version: " + stableVersion));
            SYNCHRONY_PROXY.setVersion(stableVersion);
        }
    }

    private void installSynchronyProxy(Product product) throws MojoExecutionException {
        File confInstall = this.getBaseDirectory(product);
        File war = this.goals.copyWebappWar(SYNCHRONY_PROXY, new File(confInstall, "synchrony-proxy"), "synchrony-proxy");
        SYNCHRONY_PROXY.setPath(war.getPath());
    }

    private Collection<XmlOverride> serverXmlConfluenceOverride() {
        return Collections.singletonList(new XmlOverride("conf/server.xml", "//Connector", "maxThreads", "48"));
    }

    @Override
    @Nonnull
    protected File getBundledPluginPath(Product product, File productDir) {
        String bundleDirPath = "WEB-INF/atlassian-bundled-plugins";
        File bundleDir = new File(productDir, "WEB-INF/atlassian-bundled-plugins");
        if (bundleDir.exists() && bundleDir.isDirectory()) {
            return bundleDir;
        }
        return new File(productDir, "WEB-INF/classes/com/atlassian/confluence/setup/atlassian-bundled-plugins.zip");
    }

    @Override
    @Nonnull
    protected List<ConfigFileUtils.Replacement> getReplacements(@Nonnull Product product, int nodeIndex) {
        List<ConfigFileUtils.Replacement> replacements = super.getReplacements(product, nodeIndex);
        File homeDirectory = this.getHomeDirectories(product).get(nodeIndex);
        replacements.add(new ConfigFileUtils.Replacement("@project-dir@", homeDirectory.getParent()));
        replacements.add(new ConfigFileUtils.Replacement("/confluence-home/", "/home/", false));
        String contextPath = product.getContextPath().replaceAll("^/|/$", "");
        String baseUrlElement = String.format("<baseUrl>%s://%s:%d/%s</baseUrl>", product.getProtocol(), product.getServer(), product.getWebPortForNode(nodeIndex), contextPath);
        replacements.add(new ConfigFileUtils.Replacement("<baseUrl>http://localhost:1990/confluence</baseUrl>", baseUrlElement, false));
        replacements.add(new ConfigFileUtils.Replacement("<baseUrl>http://localhost:8080</baseUrl>", baseUrlElement, false));
        return replacements;
    }

    @Override
    @Nonnull
    protected List<File> getConfigFiles(@Nonnull Product product, @Nonnull File homeDirectory) {
        List<File> configFiles = super.getConfigFiles(product, homeDirectory);
        configFiles.add(new File(new File(homeDirectory, "database"), "confluencedb.script"));
        configFiles.add(new File(new File(homeDirectory, "database"), "confluencedb.log"));
        ConfluenceProductHandler.getConfluenceConfigFile(homeDirectory).ifPresent(configFiles::add);
        return configFiles;
    }

    private static Optional<File> getConfluenceConfigFile(@Nonnull File homeDirectory) {
        return Optional.of(new File(homeDirectory, "confluence.cfg.xml")).filter(File::isFile);
    }

    @Override
    protected void cleanupProductHomeForZip(@Nonnull Product product, @Nonnull File snapshotDir) throws MojoExecutionException, IOException {
        super.cleanupProductHomeForZip(product, snapshotDir);
        FileUtils.deleteDirectory((File)new File(snapshotDir, "plugins-osgi-cache"));
        FileUtils.deleteDirectory((File)new File(snapshotDir, "plugins-temp"));
        FileUtils.deleteDirectory((File)new File(snapshotDir, "temp"));
    }

    static {
        SYNCHRONY_PROXY_VERSIONS.put(new ComparableVersion("6.4.10000"), "1.0.17");
        SYNCHRONY_PROXY_VERSIONS.put(new ComparableVersion("10000"), "RELEASE");
    }

    private static class ConfluencePluginProvider
    extends AbstractPluginProvider {
        private ConfluencePluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-confluence-plugin", salVersion));
        }

        @Override
        protected Collection<ProductArtifact> getPdkInstallArtifacts(String pdkInstallVersion) {
            return Collections.emptyList();
        }
    }
}

