/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.analytics.impl;

import com.atlassian.maven.plugins.amps.analytics.AnalyticsService;
import com.atlassian.maven.plugins.amps.analytics.event.AnalyticsEvent;
import com.atlassian.maven.plugins.amps.analytics.impl.UserAgent;
import com.atlassian.maven.plugins.amps.analytics.visitordata.PreferencesVisitorDataDao;
import com.atlassian.maven.plugins.amps.analytics.visitordata.VisitorDataDao;
import com.atlassian.maven.plugins.amps.analytics.visitordata.VisitorDataMarshaller;
import com.dmurph.tracking.AnalyticsConfigData;
import com.dmurph.tracking.JGoogleAnalyticsTracker;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

@ParametersAreNonnullByDefault
public class GoogleAnalyticsService
implements AnalyticsService {
    private static final String CATEGORY_PREFIX = "AMPS";
    private static final String TRACKING_CODE = "UA-6032469-43";
    private final AnalyticsConfigData config;
    private final JGoogleAnalyticsTracker tracker;
    private final Log log;
    private final String eventCategory;
    private final UserAgent userAgent;
    private final VisitorDataDao visitorDataDao;

    public static AnalyticsService newGoogleAnalyticsService(String productId, String sdkVersion, String ampsVersion, Log log) {
        PreferencesVisitorDataDao visitorDataDao = new PreferencesVisitorDataDao(log, new VisitorDataMarshaller());
        AnalyticsConfigData config = new AnalyticsConfigData(TRACKING_CODE, visitorDataDao.load());
        config.setFlashVersion(ampsVersion);
        JGoogleAnalyticsTracker tracker = new JGoogleAnalyticsTracker(config, JGoogleAnalyticsTracker.GoogleAnalyticsVersion.V_4_7_2);
        tracker.setDispatchMode(JGoogleAnalyticsTracker.DispatchMode.MULTI_THREAD);
        UserAgent userAgent = UserAgent.getInstance(ampsVersion, sdkVersion);
        String eventCategory = StringUtils.isBlank((CharSequence)productId) ? CATEGORY_PREFIX : "AMPS:" + productId;
        return new GoogleAnalyticsService(config, tracker, log, eventCategory, userAgent, visitorDataDao);
    }

    GoogleAnalyticsService(AnalyticsConfigData config, JGoogleAnalyticsTracker tracker, Log log, String eventCategory, UserAgent userAgent, VisitorDataDao visitorDataDao) {
        this.config = Objects.requireNonNull(config);
        this.tracker = Objects.requireNonNull(tracker);
        this.log = Objects.requireNonNull(log);
        this.eventCategory = Objects.requireNonNull(eventCategory);
        this.userAgent = Objects.requireNonNull(userAgent);
        this.visitorDataDao = Objects.requireNonNull(visitorDataDao);
    }

    @Override
    public void send(AnalyticsEvent event) {
        try {
            System.setProperty("http.agent", this.userAgent.getHeaderValue());
            this.log.info((CharSequence)("Sending event to Google Analytics: " + this.eventCategory + " - " + event));
            this.tracker.trackEvent(this.eventCategory, event.getAction(), event.getLabel());
            this.visitorDataDao.save(this.config.getVisitorData());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

