/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;

@ParametersAreNonnullByDefault
public final class PropertyUtils {
    private PropertyUtils() {
    }

    @Nonnull
    public static Properties parse(@Nullable String stringOfProperties, char keyValueDelimiter, char propertyDelimiter) {
        Properties properties = new Properties();
        String[] keyValuePairs = StringUtils.split((String)stringOfProperties, (char)propertyDelimiter);
        if (keyValuePairs != null) {
            Arrays.stream(keyValuePairs).map(pair -> StringUtils.split((String)pair, (char)keyValueDelimiter)).filter(parts -> ((String[])parts).length == 2).forEach(keyAndValue -> properties.put(keyAndValue[0], keyAndValue[1]));
        }
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static Properties load(File propertiesFile) throws MojoExecutionException {
        try (FileInputStream config = new FileInputStream(propertiesFile);){
            Properties properties = new Properties();
            properties.load(config);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not load file " + propertiesFile, (Exception)e);
        }
    }

    public static void storeProperties(Properties properties, File file, @Nullable String message) throws MojoExecutionException {
        try (FileWriter fileWriter = new FileWriter(file);){
            properties.store(fileWriter, message);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot write properties to " + file, (Exception)e);
        }
    }
}

