/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.common;

import com.atlassian.maven.plugins.amps.product.common.ValidationException;
import com.atlassian.maven.plugins.amps.product.common.XMLDocumentHandler;
import com.atlassian.maven.plugins.amps.product.common.XMLDocumentTransformer;
import com.atlassian.maven.plugins.amps.product.common.XMLDocumentValidator;
import java.util.Objects;
import org.apache.maven.plugin.MojoExecutionException;
import org.dom4j.Document;

public class XMLDocumentProcessor {
    private final XMLDocumentHandler xmlDocumentHandler;
    private boolean modified;
    private Document document;

    public XMLDocumentProcessor(XMLDocumentHandler xmlDocumentHandler) {
        this.xmlDocumentHandler = Objects.requireNonNull(xmlDocumentHandler);
    }

    public XMLDocumentProcessor load() throws MojoExecutionException {
        this.document = this.xmlDocumentHandler.read();
        return this;
    }

    public XMLDocumentProcessor validate(XMLDocumentValidator validator) throws ValidationException {
        validator.validate(this.document);
        return this;
    }

    public XMLDocumentProcessor transform(XMLDocumentTransformer transformer) throws MojoExecutionException {
        this.modified |= transformer.transform(this.document);
        return this;
    }

    public void saveIfModified() throws MojoExecutionException {
        if (this.modified) {
            this.xmlDocumentHandler.write(this.document);
        }
    }
}

