/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.database;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.database.AbstractDatabase;
import com.atlassian.maven.plugins.amps.product.ImportMethod;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@ParametersAreNonnullByDefault
public abstract class AbstractMssqlDatabase
extends AbstractDatabase {
    private static final String ARGUMENT = "argument";
    private static final String DROP_DATABASE = "USE [master]; \nIF EXISTS(SELECT * FROM SYS.DATABASES WHERE name='%s') \nDROP DATABASE [%s];\n";
    private static final String DROP_USER = "USE [master]; \nIF EXISTS(SELECT * FROM SYS.SERVER_PRINCIPALS WHERE name = '%s') \nDROP LOGIN %s; \n";
    private static final String CREATE_DATABASE = "USE [master]; \n CREATE DATABASE [%s]; \n";
    private static final String CREATE_USER = "USE [master]; \n CREATE LOGIN %s WITH PASSWORD = '%s'; \n";
    private static final String GRANT_PERMISSION = "USE [%s];\nCREATE USER %s FROM LOGIN %s; \nEXEC SP_ADDROLEMEMBER 'DB_OWNER', '%s'; \nALTER LOGIN %s WITH DEFAULT_DATABASE = [%s]; \n";

    protected AbstractMssqlDatabase(Log log, String driverClass, String urlPrefix) {
        super(log, true, "mssql", driverClass, urlPrefix);
    }

    @Override
    protected String dropDatabase(DataSource dataSource) throws MojoExecutionException {
        String databaseName = this.getDatabaseName(dataSource);
        return String.format(DROP_DATABASE, databaseName, databaseName);
    }

    @Override
    protected String dropUser(DataSource dataSource) {
        String username = dataSource.getUsername();
        return String.format(DROP_USER, username, username);
    }

    @Override
    protected String createDatabase(DataSource dataSource) throws MojoExecutionException {
        return String.format(CREATE_DATABASE, this.getDatabaseName(dataSource));
    }

    @Override
    protected String createUser(DataSource dataSource) {
        return String.format(CREATE_USER, dataSource.getUsername(), dataSource.getPassword());
    }

    @Override
    protected String grantPermissionForUser(DataSource dataSource) throws MojoExecutionException {
        String username = dataSource.getUsername();
        String databaseName = this.getDatabaseName(dataSource);
        return String.format(GRANT_PERMISSION, databaseName, username, username, username, username, databaseName);
    }

    @Override
    public Xpp3Dom getExecMavenToolImportConfiguration(DataSource dataSource) throws MojoExecutionException {
        Xpp3Dom configDatabaseTool = null;
        if (ImportMethod.SQLCMD.equals((Object)ImportMethod.getValueOf(dataSource.getImportMethod()))) {
            String databaseName = this.getDatabaseName(dataSource);
            String restoreAndGrantPermission = "\"RESTORE DATABASE [" + databaseName + "] FROM DISK='" + dataSource.getDumpFilePath() + "' WITH REPLACE; " + this.grantPermissionForUser(dataSource) + " \"";
            this.log.info((CharSequence)("MSSQL restore database and grant permission: " + restoreAndGrantPermission));
            configDatabaseTool = MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("executable"), "Sqlcmd"), MojoExecutor.element(MojoExecutor.name("arguments"), MojoExecutor.element(MojoExecutor.name(ARGUMENT), "-s"), MojoExecutor.element(MojoExecutor.name(ARGUMENT), "localhost"), MojoExecutor.element(MojoExecutor.name(ARGUMENT), "-Q"), MojoExecutor.element(MojoExecutor.name(ARGUMENT), restoreAndGrantPermission)));
        }
        return configDatabaseTool;
    }

    @Override
    protected String getDatabaseName(DataSource dataSource) throws MojoExecutionException {
        try {
            Class.forName(dataSource.getDriver());
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Could not load MSSQL database library to classpath");
        }
        try {
            Driver driver = DriverManager.getDriver(dataSource.getUrl());
            DriverPropertyInfo[] driverPropertyInfos = driver.getPropertyInfo(dataSource.getUrl(), null);
            if (null != driverPropertyInfos) {
                for (DriverPropertyInfo driverPropertyInfo : driverPropertyInfos) {
                    if (!"DATABASENAME".equalsIgnoreCase(driverPropertyInfo.name)) continue;
                    return driverPropertyInfo.value;
                }
            }
        }
        catch (SQLException e) {
            throw new MojoExecutionException("Could not detect database name from url: " + dataSource.getUrl());
        }
        return null;
    }

    @Override
    @Nonnull
    public Xpp3Dom getSqlMavenCreateConfiguration(DataSource dataSource) throws MojoExecutionException {
        String sql = this.dropDatabase(dataSource) + this.dropUser(dataSource) + this.createDatabase(dataSource) + this.createUser(dataSource) + this.grantPermissionForUser(dataSource);
        this.log.info((CharSequence)("MSSQL initialization database sql: " + sql));
        Xpp3Dom pluginConfiguration = this.systemDatabaseConfiguration(dataSource);
        pluginConfiguration.addChild(MojoExecutor.element(MojoExecutor.name("sqlCommand"), sql).toDom());
        return pluginConfiguration;
    }
}

