/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.database;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.LibArtifact;
import com.atlassian.maven.plugins.amps.database.DatabaseType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@ParametersAreNonnullByDefault
public abstract class AbstractDatabase
implements DatabaseType {
    protected final Log log;
    private final boolean hasSchema;
    private final String driverClass;
    private final String ofBizType;
    private final String urlPrefix;
    protected LibArtifact lib;

    protected AbstractDatabase(Log log, boolean hasSchema, String ofBizType, String driverClass, String urlPrefix) {
        this.log = Objects.requireNonNull(log);
        this.hasSchema = hasSchema;
        this.ofBizType = AbstractDatabase.requireNonBlank(ofBizType, "dbType");
        this.driverClass = AbstractDatabase.requireNonBlank(driverClass, "driverClass");
        this.urlPrefix = AbstractDatabase.requireNonBlank(urlPrefix, "urlPrefix");
    }

    private static String requireNonBlank(String string, String name) {
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException(String.format("Invalid %s '%s'", name, string));
        }
        return string;
    }

    protected abstract String dropDatabase(DataSource var1) throws MojoExecutionException;

    protected abstract String createDatabase(DataSource var1) throws MojoExecutionException;

    protected abstract String dropUser(DataSource var1);

    protected abstract String createUser(DataSource var1);

    protected abstract String grantPermissionForUser(DataSource var1) throws MojoExecutionException;

    protected Xpp3Dom systemDatabaseConfiguration(DataSource dataSource) {
        return MojoExecutor.configuration(AbstractDatabase.nonBlankElement("driver", dataSource.getDriver()), AbstractDatabase.nonBlankElement("url", dataSource.getSystemUrl()), AbstractDatabase.nonBlankElement("username", dataSource.getSystemUsername()), MojoExecutor.element(MojoExecutor.name("password"), dataSource.getSystemPassword()), MojoExecutor.element(MojoExecutor.name("autocommit"), "true"));
    }

    private static MojoExecutor.Element nonBlankElement(String name, String value) {
        return MojoExecutor.element(MojoExecutor.name(name), AbstractDatabase.requireNonBlank(value, name));
    }

    protected Xpp3Dom productDatabaseConfiguration(DataSource dataSource) {
        return MojoExecutor.configuration(AbstractDatabase.nonBlankElement("driver", dataSource.getDriver()), AbstractDatabase.nonBlankElement("url", dataSource.getUrl()), AbstractDatabase.nonBlankElement("username", dataSource.getUsername()), MojoExecutor.element(MojoExecutor.name("password"), dataSource.getPassword()), MojoExecutor.element(MojoExecutor.name("autocommit"), "true"));
    }

    @Nullable
    protected abstract String getDatabaseName(DataSource var1) throws MojoExecutionException;

    @Override
    @Nonnull
    public List<Dependency> getSqlMavenDependencies(DataSource dataSource) {
        if (dataSource.getLibArtifacts() == null) {
            return Collections.emptyList();
        }
        return dataSource.getLibArtifacts().stream().map(LibArtifact::asDependency).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public Xpp3Dom getSqlMavenFileImportConfiguration(DataSource dataSource) {
        Xpp3Dom pluginConfiguration = this.productDatabaseConfiguration(dataSource);
        pluginConfiguration.addChild(MojoExecutor.element(MojoExecutor.name("srcFiles"), MojoExecutor.element(MojoExecutor.name("srcFile"), dataSource.getDumpFilePath())).toDom());
        return pluginConfiguration;
    }

    @Override
    public Xpp3Dom getExecMavenToolImportConfiguration(DataSource dataSource) throws MojoExecutionException {
        return null;
    }

    @Override
    public final boolean hasSchema() {
        return this.hasSchema;
    }

    @Override
    @Nonnull
    public String getOfBizName() {
        return this.ofBizType;
    }

    @Override
    public boolean isTypeOf(DataSource dataSource) {
        return this.startsWithExpectedPrefix(dataSource.getUrl()) && this.driverClass.equals(dataSource.getDriver());
    }

    private boolean startsWithExpectedPrefix(@Nullable String jdbcUrl) {
        return jdbcUrl != null && jdbcUrl.trim().startsWith(this.urlPrefix);
    }
}

