/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractTestGroupsHandlerMojo;
import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.LibArtifact;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.database.DatabaseType;
import com.atlassian.maven.plugins.amps.database.DatabaseTypeFactory;
import com.atlassian.maven.plugins.amps.product.ImportMethod;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="prepare-database", requiresDependencyResolution=ResolutionScope.TEST)
public class PrepareDatabaseMojo
extends AbstractTestGroupsHandlerMojo {
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean testsSkip;
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="db.dump.file.path")
    private String dumpFilePath;
    @Parameter(property="import.method")
    private String importMethod;
    @Parameter(property="db.default.database")
    private String defaultDatabase;
    @Parameter(property="db.system.username")
    private String systemUsername;
    @Parameter(property="db.system.password")
    private String systemPassword;

    @Override
    protected void doExecute() throws MojoExecutionException {
        if (this.testsSkip || this.skipTests) {
            this.getLog().info((CharSequence)"Database preparation skipped");
            return;
        }
        for (Product product : this.getProductsToExecute()) {
            DataSource dataSource = this.getOnlyDataSource(product);
            if (dataSource == null) continue;
            DatabaseType databaseType = this.getDatabaseType(dataSource);
            dataSource.getLibArtifacts().addAll(this.getJdbcDriverArtifacts(product));
            if (dataSource.getLibArtifacts().isEmpty()) {
                throw new MojoExecutionException("Neither the DataSource nor the Product have library artifacts, no JDBC driver found for database: " + databaseType.getOfBizName());
            }
            this.populateParameters(dataSource);
            if (PrepareDatabaseMojo.shouldDropAndReCreateDatabase(dataSource, product)) {
                this.dropAndReCreate(databaseType, dataSource);
            }
            if (!StringUtils.isNotEmpty((CharSequence)dataSource.getDumpFilePath())) continue;
            this.importDumpFile(databaseType, dataSource);
        }
    }

    @VisibleForTesting
    static boolean shouldDropAndReCreateDatabase(DataSource dataSource, Product product) {
        return dataSource.isDropAndReCreateDatabase() || product.is("jira");
    }

    @Nullable
    private DataSource getOnlyDataSource(Product product) {
        List<DataSource> dataSources = product.getDataSources();
        switch (dataSources.size()) {
            case 0: {
                this.getLog().info((CharSequence)"No dataSource configured; skipping database preparation");
                return null;
            }
            case 1: {
                return dataSources.get(0);
            }
        }
        this.getLog().info((CharSequence)("Multiple dataSources not supported. Configuration has these " + dataSources.size() + " dataSources:"));
        for (DataSource dataSource : dataSources) {
            this.getLog().info((CharSequence)("- Database URL: " + dataSource.getUrl()));
        }
        return null;
    }

    private DatabaseType getDatabaseType(DataSource dataSource) throws MojoExecutionException {
        return new DatabaseTypeFactory(this.getLog()).getDatabaseType(dataSource).orElseThrow(() -> new MojoExecutionException("Could not detect database type for dataSource: " + dataSource));
    }

    private Collection<LibArtifact> getJdbcDriverArtifacts(Product product) {
        return product.getLibArtifacts().stream().map(this::toLibArtifact).collect(Collectors.toList());
    }

    private LibArtifact toLibArtifact(ProductArtifact productArtifact) {
        return new LibArtifact(productArtifact.getGroupId(), productArtifact.getArtifactId(), productArtifact.getVersion());
    }

    private void populateParameters(DataSource dataSource) {
        if (StringUtils.isNotEmpty((CharSequence)this.defaultDatabase)) {
            dataSource.setSystemUrl(this.defaultDatabase);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.systemUsername)) {
            dataSource.setSystemUsername(this.systemUsername);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.systemPassword)) {
            dataSource.setSystemPassword(this.systemPassword);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.dumpFilePath)) {
            dataSource.setDumpFilePath(this.dumpFilePath);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.importMethod)) {
            dataSource.setImportMethod(this.importMethod);
        } else {
            dataSource.setImportMethod(ImportMethod.SQL.getMethod());
        }
    }

    private void dropAndReCreate(DatabaseType databaseType, DataSource dataSource) throws MojoExecutionException {
        this.mojoExecutorWrapper.executeWithMergedConfig(this.getSqlMavenPlugin(databaseType, dataSource), MojoExecutor.goal("execute"), databaseType.getSqlMavenCreateConfiguration(dataSource), this.getMavenContext().getExecutionEnvironment());
    }

    private Plugin getSqlMavenPlugin(DatabaseType databaseType, DataSource dataSource) {
        Plugin sqlMavenPlugin = this.getMavenContext().getPlugin("org.codehaus.mojo", "sql-maven-plugin");
        ArrayList<Dependency> pluginDependencies = new ArrayList<Dependency>(sqlMavenPlugin.getDependencies());
        pluginDependencies.addAll(databaseType.getSqlMavenDependencies(dataSource));
        sqlMavenPlugin.setDependencies(pluginDependencies);
        return sqlMavenPlugin;
    }

    private void importDumpFile(DatabaseType databaseType, DataSource dataSource) throws MojoExecutionException {
        String dumpFileName = dataSource.getDumpFilePath();
        File dumpFile = new File(dumpFileName);
        if (!dumpFile.isFile()) {
            throw new MojoExecutionException(String.format("Import file '%s' is not a file", dumpFileName));
        }
        this.getLog().info((CharSequence)("Importing dump file: " + dumpFileName + " into " + databaseType.getOfBizName() + " using " + dataSource.getImportMethod()));
        if (ImportMethod.SQL == ImportMethod.getValueOf(dataSource.getImportMethod())) {
            this.importSqlDumpFile(databaseType, dataSource);
        } else {
            this.importDataUsingDatabaseSpecificTool(databaseType, dataSource);
        }
    }

    private void importSqlDumpFile(DatabaseType databaseType, DataSource dataSource) throws MojoExecutionException {
        this.mojoExecutorWrapper.executeWithMergedConfig(this.getSqlMavenPlugin(databaseType, dataSource), MojoExecutor.goal("execute"), databaseType.getSqlMavenFileImportConfiguration(dataSource), this.getMavenContext().getExecutionEnvironment());
    }

    private void importDataUsingDatabaseSpecificTool(DatabaseType databaseType, DataSource dataSource) throws MojoExecutionException {
        Xpp3Dom importConfiguration = databaseType.getExecMavenToolImportConfiguration(dataSource);
        if (importConfiguration == null) {
            this.getLog().warn((CharSequence)String.format("No configuration provided for %s - skipping import", databaseType));
        } else {
            this.mojoExecutorWrapper.executeWithMergedConfig(this.getMavenContext().getPlugin("org.codehaus.mojo", "exec-maven-plugin"), MojoExecutor.goal("exec"), importConfiguration, this.getMavenContext().getExecutionEnvironment());
        }
    }
}

