/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import java.util.Enumeration;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class StreamUtils {
    private StreamUtils() {
    }

    public static <T> Stream<T> stream(@Nullable Enumeration<T> enumeration) {
        if (enumeration == null) {
            return Stream.empty();
        }
        EnumerationSpliterator spliterator = new EnumerationSpliterator(enumeration);
        return StreamSupport.stream(spliterator, false);
    }

    private static class EnumerationSpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private final Enumeration<T> enumeration;

        private EnumerationSpliterator(Enumeration<T> enumeration) {
            super(Long.MAX_VALUE, 16);
            this.enumeration = Objects.requireNonNull(enumeration);
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (this.enumeration.hasMoreElements()) {
                action.accept(this.enumeration.nextElement());
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            while (this.enumeration.hasMoreElements()) {
                action.accept(this.enumeration.nextElement());
            }
        }
    }
}

