/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public final class PluginXmlUtils {
    private static final String XPATH_PLUGIN = "/atlassian-plugin";
    private static final String XPATH_PLUGIN_INFO = "/atlassian-plugin/plugin-info";
    private static final String XPATH_REST = "/atlassian-plugin/rest";
    private static final String XPATH_PACKAGE_RELATIVE = "package";

    public static PluginInfo getPluginInfo(MavenContext context) {
        File pluginXml = PluginXmlUtils.getPluginXml(context);
        PluginInfo pluginInfo = null;
        if (pluginXml.exists()) {
            try {
                Document pluginDoc = PluginXmlUtils.getXmlDocument(pluginXml);
                Node root = pluginDoc.selectSingleNode(XPATH_PLUGIN);
                String name = "";
                String desc = "";
                if (null != root) {
                    Node descNode;
                    name = root.valueOf("@name");
                    Node infoNode = pluginDoc.selectSingleNode(XPATH_PLUGIN_INFO);
                    if (null != infoNode && null != (descNode = infoNode.selectSingleNode("description"))) {
                        desc = descNode.valueOf("text()");
                    }
                }
                pluginInfo = new PluginInfo(name, desc);
            }
            catch (Exception e) {
                context.getLog().warn((CharSequence)e.getMessage());
            }
        }
        if (null == pluginInfo) {
            pluginInfo = new PluginInfo("unknown plugin", "");
        }
        return pluginInfo;
    }

    public static List<RESTModuleInfo> getRestModules(MavenContext context) {
        File pluginXml = PluginXmlUtils.getPluginXml(context);
        if (!pluginXml.isFile()) {
            context.getLog().error((CharSequence)(pluginXml + " is not a file; have you run the process-resources phase?"));
            return Collections.emptyList();
        }
        ArrayList<RESTModuleInfo> modules = new ArrayList<RESTModuleInfo>();
        try {
            Document pluginDoc = PluginXmlUtils.getXmlDocument(pluginXml);
            List restNodes = pluginDoc.selectNodes(XPATH_REST);
            restNodes.stream().map(PluginXmlUtils::getRestModule).forEach(modules::add);
        }
        catch (Exception e) {
            context.getLog().warn((CharSequence)e.getMessage());
        }
        return modules;
    }

    private static RESTModuleInfo getRestModule(Node restNode) {
        Node descNode;
        String name = restNode.valueOf("@name");
        String desc = restNode.valueOf("@description");
        ArrayList<String> packagesToScan = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)desc) && null != (descNode = restNode.selectSingleNode("description"))) {
            desc = descNode.valueOf("text()");
        }
        List packageNodes = restNode.selectNodes(XPATH_PACKAGE_RELATIVE);
        for (Node packageNode : packageNodes) {
            packagesToScan.add(packageNode.valueOf("text()"));
        }
        return new RESTModuleInfo(name, desc, packagesToScan);
    }

    @Nonnull
    public static File getPluginXml(MavenContext context) {
        return FileUtils.file(context.getProject().getBuild().getOutputDirectory(), "atlassian-plugin.xml");
    }

    protected static Document getXmlDocument(File xmlFile) throws DocumentException {
        SAXReader reader = new SAXReader();
        return reader.read(xmlFile);
    }

    private PluginXmlUtils() {
    }

    public static class PluginInfo {
        private String name;
        private String description;

        public PluginInfo(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class RESTModuleInfo {
        private String name;
        private String description;
        private List<String> packagesToScan;

        public RESTModuleInfo(String name, String description, List<String> packagesToScan) {
            this.name = name;
            this.description = description;
            this.packagesToScan = packagesToScan;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getPackagesToScan() {
            return this.packagesToScan;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

