/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractWebappProductHandler;
import com.atlassian.maven.plugins.amps.product.manager.WebAppManager;
import com.atlassian.maven.plugins.amps.util.JvmArgsFix;
import com.atlassian.maven.plugins.amps.util.VersionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.repository.RepositorySystem;

public class RefappProductHandler
extends AbstractWebappProductHandler {
    @VisibleForTesting
    static final String ATLASSIAN_BUNDLED_PLUGINS_ZIP = "WEB-INF/classes/atlassian-bundled-plugins.zip";
    @VisibleForTesting
    static final String ATLASSIAN_BUNDLED_PLUGINS_DIR = "WEB-INF/atlassian-bundled-plugins";

    public RefappProductHandler(MavenContext context, MavenGoals goals, RepositorySystem repositorySystem, ArtifactResolver artifactResolver, WebAppManager webAppManager) {
        super(context, goals, new RefappPluginProvider(), repositorySystem, artifactResolver, webAppManager);
    }

    @Override
    @Nonnull
    public String getDefaultContainerId() {
        return "tomcat7x";
    }

    @Override
    @Nonnull
    public String getId() {
        return "refapp";
    }

    @Override
    public int getDefaultHttpPort() {
        return 5990;
    }

    @Override
    public int getDefaultHttpsPort() {
        return 8445;
    }

    @Override
    @Nonnull
    protected Optional<File> getUserInstalledPluginsDirectory(Product product, File webappDir, File homeDir) {
        return Optional.empty();
    }

    @Override
    @Nonnull
    protected File getBundledPluginPath(Product product, File productDir) {
        File bundleDir = new File(productDir, ATLASSIAN_BUNDLED_PLUGINS_DIR);
        if (bundleDir.exists() && bundleDir.isDirectory()) {
            return bundleDir;
        }
        return new File(productDir, ATLASSIAN_BUNDLED_PLUGINS_ZIP);
    }

    @Override
    @Nonnull
    protected Map<String, String> getProductSpecificSystemProperties(Product product, int nodeIndex) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"refapp.home", (Object)this.getHomeDirectory(product).getPath());
        properties.put((Object)"osgi.cache", (Object)(this.getHomeDirectory(product).getPath() + "/osgi-cache"));
        properties.put((Object)"bundledplugins.cache", (Object)(this.getHomeDirectory(product).getPath() + "/bundled-plugins"));
        properties.put((Object)"cargo.servlet.uriencoding", (Object)"UTF-8");
        properties.putAll(this.getExternalDatabaseSystemProperties(product));
        return properties.build();
    }

    private File getHomeDirectory(Product product) {
        List<File> homeDirectories = this.getHomeDirectories(product);
        if (homeDirectories.size() == 1) {
            return homeDirectories.get(0);
        }
        throw new IllegalStateException("Expected one home directory but found " + homeDirectories);
    }

    @Nonnull
    private Map<String, String> getExternalDatabaseSystemProperties(Product refapp) {
        return refapp.getDataSources().stream().findFirst().map(ds -> {
            ImmutableMap.Builder externalDbProperties = ImmutableMap.builder();
            externalDbProperties.put((Object)"refapp.jdbc.external", (Object)"true");
            externalDbProperties.put((Object)"refapp.jdbc.app.url", (Object)RefappProductHandler.nonBlankValue(ds.getUrl(), "url"));
            externalDbProperties.put((Object)"refapp.jdbc.app.user", (Object)RefappProductHandler.nonBlankValue(ds.getUsername(), "username"));
            externalDbProperties.put((Object)"refapp.jdbc.app.pass", (Object)RefappProductHandler.nonBlankValue(ds.getPassword(), "password"));
            externalDbProperties.put((Object)"refapp.jdbc.driver.class.name", (Object)RefappProductHandler.nonBlankValue(ds.getDriver(), "driver"));
            if (StringUtils.isNotBlank((CharSequence)ds.getSchema())) {
                externalDbProperties.put((Object)"refapp.jdbc.app.schema", (Object)ds.getSchema());
            }
            if (StringUtils.isNotBlank((CharSequence)ds.getValidationQuery())) {
                externalDbProperties.put((Object)"refapp.jdbc.validation.query", (Object)ds.getValidationQuery());
            }
            return externalDbProperties.build();
        }).orElse(Collections.emptyMap());
    }

    private static String nonBlankValue(String value, String name) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException(String.format("Invalid dataSource.%s value '%s'", name, value));
        }
        return value.trim();
    }

    @Override
    @Nonnull
    public ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.refapp", "atlassian-refapp", VersionUtils.getVersion());
    }

    @Override
    @Nonnull
    public Optional<ProductArtifact> getTestResourcesArtifact() {
        return Optional.empty();
    }

    @Override
    protected void fixJvmArgs(Product product) {
        String jvmArgs = JvmArgsFix.defaults().withAddOpens(ADD_OPENS_FOR_TOMCAT).withAddOpens(ADD_OPENS_FOR_FELIX).apply(product.getJvmArgs());
        product.setJvmArgs(jvmArgs);
    }

    private static class RefappPluginProvider
    extends AbstractPluginProvider {
        private RefappPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-appproperties-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-component-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-executor-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-lifecycle-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-message-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-net-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-pluginsettings-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-project-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-search-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-transaction-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-upgrade-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-user-plugin", salVersion));
        }

        @Override
        protected Collection<ProductArtifact> getPdkInstallArtifacts(String pdkInstallVersion) {
            return Collections.emptyList();
        }
    }
}

