/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.atlassian.maven.plugins.amps.util.MojoExecutorWrapper;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.twdata.maven.mojoexecutor.MavenCompatibilityHelper;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class MojoExecutorWrapperImpl
implements MojoExecutorWrapper {
    @Override
    public void execute(Plugin plugin, String goal, Xpp3Dom configuration, MojoExecutor.ExecutionEnvironment executionEnvironment) throws MojoExecutionException {
        MojoExecutor.executeMojo(plugin, goal, configuration, executionEnvironment);
    }

    @Override
    public void executeWithMergedConfig(Plugin plugin, String goal, Xpp3Dom configuration, MojoExecutor.ExecutionEnvironment executionEnvironment) throws MojoExecutionException {
        Xpp3Dom mergedConfig = this.mergeConfig(plugin, goal, configuration, executionEnvironment);
        this.execute(plugin, goal, mergedConfig, executionEnvironment);
    }

    private Xpp3Dom getGoalConfig(Plugin plugin, String goal, MavenProject project) {
        String executionId;
        int index = goal.indexOf(35);
        if (index == -1) {
            executionId = null;
        } else {
            executionId = goal.substring(index + 1);
            goal = goal.substring(0, index);
        }
        return project.getGoalConfiguration(plugin.getGroupId(), plugin.getArtifactId(), executionId, goal);
    }

    private List<Parameter> getGoalParameters(Plugin plugin, String goal, MojoExecutor.ExecutionEnvironment executionEnvironment) throws MojoExecutionException {
        PluginDescriptor pluginDescriptor;
        try {
            pluginDescriptor = MavenCompatibilityHelper.loadPluginDescriptor(plugin, executionEnvironment, executionEnvironment.getMavenSession());
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to load descriptor for " + plugin.getGroupId() + ":" + plugin.getArtifactId(), e);
        }
        return pluginDescriptor.getMojo(goal).getParameters();
    }

    private Xpp3Dom mergeConfig(Plugin plugin, String goal, Xpp3Dom defaultConfig, MojoExecutor.ExecutionEnvironment executionEnvironment) throws MojoExecutionException {
        Xpp3Dom goalConfig = this.getGoalConfig(plugin, goal, executionEnvironment.getMavenProject());
        if (goalConfig == null) {
            return defaultConfig;
        }
        Xpp3Dom merged = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)goalConfig, (Xpp3Dom)defaultConfig, (Boolean)true);
        List<Parameter> parameters = this.getGoalParameters(plugin, goal, executionEnvironment);
        if (parameters == null || parameters.isEmpty()) {
            return merged;
        }
        Xpp3Dom finalConfig = MojoExecutor.configuration(new MojoExecutor.Element[0]);
        for (Parameter parameter : parameters) {
            Xpp3Dom element = merged.getChild(parameter.getName());
            if (element == null && parameter.getAlias() != null) {
                element = merged.getChild(parameter.getAlias());
            }
            if (element == null) continue;
            finalConfig.addChild(element);
        }
        return finalConfig;
    }
}

