/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class JvmArgsFix {
    private final Map<String, String> defaultParams;

    private JvmArgsFix(Map<String, String> initial) {
        this.defaultParams = Maps.newLinkedHashMap(initial);
    }

    private JvmArgsFix() {
        this.defaultParams = Maps.newLinkedHashMap();
    }

    public static JvmArgsFix defaults() {
        return new JvmArgsFix((Map<String, String>)ImmutableMap.of((Object)"-Xmx", (Object)"512m"));
    }

    public static JvmArgsFix empty() {
        return new JvmArgsFix();
    }

    public JvmArgsFix with(String param, String value) {
        this.defaultParams.put(param, value);
        return this;
    }

    public String apply(String jvmArgs) {
        ArrayList args = StringUtils.isNotBlank((CharSequence)jvmArgs) ? Lists.newArrayList((Object[])new String[]{jvmArgs}) : Lists.newArrayList();
        for (Map.Entry<String, String> param : this.defaultParams.entrySet()) {
            if (StringUtils.contains((CharSequence)jvmArgs, (CharSequence)param.getKey())) continue;
            args.add(param.getKey() + param.getValue());
        }
        return StringUtils.join((Iterable)args, (char)' ');
    }
}

