/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.jira.config;

import com.atlassian.maven.plugins.amps.product.common.XMLDocumentTransformer;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseType;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class SchemeUpdaterTransformer
implements XMLDocumentTransformer {
    private final JiraDatabaseType jiraDatabaseType;
    private final String schema;

    public SchemeUpdaterTransformer(JiraDatabaseType jiraDatabaseType, String schema) {
        this.jiraDatabaseType = jiraDatabaseType;
        this.schema = schema;
    }

    @Override
    public boolean transform(Document document) throws MojoExecutionException {
        Node schemaNode = document.selectSingleNode("/jira-database-config/schema-name");
        if (this.jiraDatabaseType.hasSchema()) {
            if (StringUtils.isEmpty((CharSequence)this.schema)) {
                throw new MojoExecutionException("Database configuration is missing the schema");
            }
            if (null == schemaNode) {
                ((Element)document.selectSingleNode("/jira-database-config")).addElement("schema-name").addText(this.schema);
                return true;
            }
            if (StringUtils.isNotEmpty((CharSequence)schemaNode.getText()) && !this.schema.equals(schemaNode.getText())) {
                schemaNode.setText(this.schema);
                return true;
            }
        } else if (schemaNode != null) {
            schemaNode.detach();
            return true;
        }
        return false;
    }
}

