/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XMLDocumentHandler {
    protected final File file;

    public XMLDocumentHandler(File file) {
        this.file = file;
    }

    protected Document read() throws MojoExecutionException {
        SAXReader reader = new SAXReader();
        try {
            return reader.read(this.file);
        }
        catch (DocumentException ex) {
            throw new MojoExecutionException("Cannot parse XML file: " + this.file.getName(), (Exception)((Object)ex));
        }
    }

    protected void write(Document document) throws MojoExecutionException {
        try (FileOutputStream fos = new FileOutputStream(this.file);){
            XMLWriter writer = new XMLWriter((OutputStream)fos, OutputFormat.createPrettyPrint());
            writer.write(document);
            writer.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write updated XML file: " + this.file.getName(), (Exception)e);
        }
    }
}

