/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductAwareMojo;
import com.atlassian.maven.plugins.amps.codegen.ConditionFactory;
import com.atlassian.maven.plugins.amps.codegen.ContextProviderFactory;
import com.atlassian.maven.plugins.amps.codegen.PluginModuleSelectionQueryer;
import com.atlassian.maven.plugins.amps.codegen.jira.ActionTypeFactory;
import com.atlassian.maven.plugins.amps.codegen.jira.CustomFieldSearcherFactory;
import com.atlassian.maven.plugins.amps.codegen.jira.CustomFieldTypeFactory;
import com.atlassian.maven.plugins.amps.codegen.prompter.PluginModulePrompter;
import com.atlassian.maven.plugins.amps.codegen.prompter.PluginModulePrompterFactory;
import com.atlassian.plugins.codegen.MavenProjectRewriter;
import com.atlassian.plugins.codegen.PluginProjectChangeset;
import com.atlassian.plugins.codegen.PluginXmlRewriter;
import com.atlassian.plugins.codegen.ProjectFilesRewriter;
import com.atlassian.plugins.codegen.modules.PluginModuleCreator;
import com.atlassian.plugins.codegen.modules.PluginModuleCreatorFactory;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.PluginModuleProperties;
import java.io.File;
import java.util.List;
import java.util.function.BinaryOperator;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="create-plugin-module", requiresDependencyResolution=ResolutionScope.COMPILE)
public class PluginModuleGenerationMojo
extends AbstractProductAwareMojo {
    private static final BinaryOperator<String> FIND_LAST = (first, second) -> second;
    @Component
    private PluginModuleSelectionQueryer pluginModuleSelectionQueryer;
    @Component
    private PluginModulePrompterFactory pluginModulePrompterFactory;
    @Component
    private PluginModuleCreatorFactory pluginModuleCreatorFactory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.trackFirstRunIfNeeded();
        Log log = this.getLog();
        this.pluginModulePrompterFactory.setLog(log);
        try {
            this.pluginModulePrompterFactory.scanForPrompters();
        }
        catch (Exception e) {
            String message = "Error initializing Plugin Module Prompters";
            log.error((CharSequence)message);
            throw new MojoExecutionException(message);
        }
        String productId = this.getProductId();
        MavenProject project = this.getMavenContext().getProject();
        File javaDir = this.getJavaSourceRoot(project);
        File testDir = this.getJavaTestRoot(project);
        File resourcesDir = this.getResourcesRoot(project);
        this.initHelperFactories(productId, project);
        PluginModuleLocation moduleLocation = new PluginModuleLocation.Builder(javaDir).resourcesDirectory(resourcesDir).testDirectory(testDir).templateDirectory(new File(resourcesDir, "templates")).groupAndArtifactId(project.getGroupId(), project.getArtifactId()).build();
        if (!moduleLocation.getPluginXml().exists()) {
            String message = "Couldn't find the atlassian-plugin.xml, please run this goal in an atlassian plugin project root.";
            log.error((CharSequence)message);
            throw new MojoExecutionException(message);
        }
        this.runGeneration(productId, project, moduleLocation);
    }

    private void runGeneration(String productId, MavenProject project, PluginModuleLocation moduleLocation) throws MojoExecutionException {
        try {
            PluginModuleCreator creator = this.pluginModuleSelectionQueryer.selectModule(this.pluginModuleCreatorFactory.getModuleCreatorsForProduct(productId));
            String trackingLabel = this.getPluginInformation().getId() + ":" + creator.getModuleName();
            this.getGoogleTracker().track("Create Plugin Module", trackingLabel);
            PluginModulePrompter modulePrompter = this.pluginModulePrompterFactory.getPrompterForCreatorClass(creator.getClass());
            if (modulePrompter == null) {
                String message = "Couldn't find an input prompter for: " + creator.getClass().getName();
                this.getLog().error((CharSequence)message);
                throw new MojoExecutionException(message);
            }
            modulePrompter.setDefaultBasePackage(project.getGroupId());
            modulePrompter.setPluginKey(project.getGroupId() + "." + project.getArtifactId());
            PluginModuleProperties moduleProps = modulePrompter.getModulePropertiesFromInput(moduleLocation);
            moduleProps.setProductId(this.getGadgetCompatibleProductId(productId));
            PluginProjectChangeset changeset = creator.createModule(moduleProps);
            this.getLog().info((CharSequence)"Adding the following items to the project:");
            for (String desc : changeset.getChangeDescriptionsOrSummaries()) {
                this.getLog().info((CharSequence)("  " + desc));
            }
            this.editPomIfNeeded(project, changeset);
            new ProjectFilesRewriter(moduleLocation).applyChanges(changeset);
            new PluginXmlRewriter(moduleLocation).applyChanges(changeset);
            if (this.pluginModuleSelectionQueryer.addAnotherModule()) {
                this.runGeneration(productId, project, moduleLocation);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating plugin module", e);
        }
    }

    private void editPomIfNeeded(MavenProject project, PluginProjectChangeset changeset) {
        try {
            new MavenProjectRewriter(project.getFile()).applyChanges(changeset);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Unable to apply changes to POM: " + e));
        }
    }

    private String getGadgetCompatibleProductId(String pid) {
        switch (pid) {
            case "bamboo": {
                return "Bamboo";
            }
            case "confluence": {
                return "Confluence";
            }
            case "crowd": {
                return "Crowd";
            }
            case "fecru": {
                return "FishEye";
            }
            case "jira": {
                return "JIRA";
            }
        }
        return "Other";
    }

    private File getJavaSourceRoot(MavenProject project) {
        return new File(project.getModel().getBuild().getSourceDirectory());
    }

    private File getJavaTestRoot(MavenProject project) {
        return new File(project.getModel().getBuild().getTestSourceDirectory());
    }

    private File getResourcesRoot(MavenProject project) {
        String pathToCheck = "src" + File.separator + "main" + File.separator + "resources";
        return project.getModel().getBuild().getResources().stream().map(FileSet::getDirectory).filter(dir -> StringUtils.endsWith((CharSequence)dir, (CharSequence)pathToCheck)).reduce(FIND_LAST).map(File::new).orElse(null);
    }

    private void initHelperFactories(String productId, MavenProject project) throws MojoExecutionException {
        String message;
        List pluginClasspath;
        try {
            pluginClasspath = project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Dependencies MUST be resolved", (Exception)((Object)e));
        }
        try {
            ConditionFactory.locateAvailableConditions((String)productId, (List)pluginClasspath);
        }
        catch (Exception e) {
            message = "Error initializing Plugin Module Conditions";
            this.getLog().error((CharSequence)message);
        }
        try {
            ContextProviderFactory.locateAvailableContextProviders((String)productId, (List)pluginClasspath);
        }
        catch (Exception e) {
            message = "Error initializing Plugin Module Context Providers";
            this.getLog().error((CharSequence)message);
        }
        if ("jira".equals(productId)) {
            try {
                ActionTypeFactory.locateAvailableActionTypes((List)pluginClasspath);
            }
            catch (Exception e) {
                message = "Error initializing JIRA Action Types";
                this.getLog().error((CharSequence)message);
            }
            try {
                CustomFieldTypeFactory.locateAvailableCustomFieldTypes((List)pluginClasspath);
            }
            catch (Exception e) {
                message = "Error initializing JIRA Custom Field Types";
                this.getLog().error((CharSequence)message);
            }
            try {
                CustomFieldSearcherFactory.locateAvailableCustomFieldSearchers((List)pluginClasspath);
            }
            catch (Exception e) {
                message = "Error initializing JIRA Custom Field Searchers";
                this.getLog().error((CharSequence)message);
            }
        }
    }
}

