/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractTestGroupsHandlerMojo;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.ProductExecution;
import com.atlassian.maven.plugins.amps.TestGroup;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="integration-test", requiresDependencyResolution=ResolutionScope.TEST)
public class IntegrationTestMojo
extends AbstractTestGroupsHandlerMojo {
    @Parameter(property="functional.test.pattern")
    private String functionalTestPattern = "%regex[it[/\\\\].*]";
    @Parameter(property="project.build.testOutputDirectory", required=true)
    private File testClassesDirectory;
    @Parameter(property="testGroups")
    private String configuredTestGroupsToRun;
    @Parameter(property="no.webapp", defaultValue="false")
    private boolean noWebapp;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean testsSkip;
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="skipITs", defaultValue="false")
    private boolean skipITs;
    @Parameter(property="jvm.debug.port", defaultValue="0")
    protected int jvmDebugPort;
    @Parameter(property="jvm.debug.suspend")
    protected boolean jvmDebugSuspend;
    @Parameter(property="maven.failsafe.debug")
    protected String mavenFailsafeDebug;
    @Parameter
    protected String category;
    @Parameter(property="skip.IT.verification")
    protected boolean skipITVerification;

    @Override
    protected void doExecute() throws MojoExecutionException {
        if (!new File(this.testClassesDirectory, "it").exists()) {
            this.getLog().info((CharSequence)"No integration tests found");
            return;
        }
        if (this.skipTests || this.testsSkip || this.skipITs) {
            this.getLog().info((CharSequence)"Integration tests skipped");
            return;
        }
        MavenProject project = this.getMavenContext().getProject();
        project.getArtifact().setArtifactHandler(this.artifactHandlerManager.getArtifactHandler("jar"));
        MavenGoals goals = this.getMavenGoals();
        String pluginJar = this.targetDirectory.getAbsolutePath() + "/" + this.finalName + ".jar";
        for (String testGroupId : this.getTestGroupsToRun()) {
            this.runTestsForTestGroup(testGroupId, goals, pluginJar, IntegrationTestMojo.copy(this.systemPropertyVariables));
        }
    }

    private Collection<String> getTestGroupsToRun() {
        Set<String> superclassTestGroupIds = this.getTestGroupIds();
        if (superclassTestGroupIds.isEmpty()) {
            return Collections.singleton("__no_test_group__");
        }
        if (this.configuredTestGroupsToRun == null) {
            return superclassTestGroupIds;
        }
        HashSet<String> testGroupIdsInCommonWithSuperclass = new HashSet<String>();
        for (String testGroupId : this.configuredTestGroupsToRun.split(",")) {
            if (superclassTestGroupIds.contains(testGroupId)) {
                testGroupIdsInCommonWithSuperclass.add(testGroupId);
                continue;
            }
            this.getLog().warn((CharSequence)("Test group '" + testGroupId + "' does not exist"));
        }
        return testGroupIdsInCommonWithSuperclass;
    }

    private static Map<String, Object> copy(Map<String, Object> mapIn) {
        return new HashMap<String, Object>(mapIn);
    }

    protected Map<String, String> getProductFunctionalTestProperties(Product product) {
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestsForTestGroup(String testGroupId, MavenGoals goals, String pluginJar, Map<String, Object> systemProperties) throws MojoExecutionException {
        List<String> includes = this.getIncludesForTestGroup(testGroupId);
        List<String> excludes = this.getExcludesForTestGroup(testGroupId);
        List<ProductExecution> productExecutions = this.getTestGroupProductExecutions(testGroupId);
        this.setParallelMode(productExecutions);
        ArrayList<String> instanceIds = new ArrayList<String>();
        HashMap<Integer, ProductExecution> productExecutionWithActualPorts = new HashMap<Integer, ProductExecution>();
        int counter = 0;
        for (ProductExecution productExecution : productExecutions) {
            int actualHttpPort;
            ProductHandler productHandler = productExecution.getProductHandler();
            Product product = productExecution.getProduct();
            instanceIds.add(product.getInstanceId());
            if (product.isInstallPlugin() == null) {
                product.setInstallPlugin(this.installPlugin);
            }
            if (this.shouldBuildTestPlugin()) {
                List<ProductArtifact> plugins = product.getBundledArtifacts();
                plugins.addAll(this.getTestFrameworkPlugins());
            }
            if (this.noWebapp) {
                actualHttpPort = product.getHttpPort();
                if (actualHttpPort <= 0) {
                    throw new MojoExecutionException("Http server port must be set when using no.webapp flag.");
                }
            } else {
                if (this.jvmDebugPort > 0) {
                    counter = this.setUpDebugging(counter, product);
                }
                actualHttpPort = productHandler.start(product);
            }
            if (productExecutionWithActualPorts.put(actualHttpPort, productExecution) == null) continue;
            throw new MojoExecutionException("Http server port was already occupied");
        }
        this.populateProperties(systemProperties, testGroupId, pluginJar, instanceIds, productExecutionWithActualPorts);
        if (!this.noWebapp) {
            this.waitForProducts(productExecutions, true);
        }
        MojoExecutionException thrown = null;
        try {
            String reportsDirectory = MavenGoals.getReportsDirectory(this.targetDirectory, "group-" + testGroupId, this.getClassifier(testGroupId));
            goals.runIntegrationTests(reportsDirectory, includes, excludes, systemProperties, this.category, this.mavenFailsafeDebug);
            if (this.skipITVerification) {
                this.getLog().info((CharSequence)"Skipping failsafe IT failure verification.");
            } else {
                goals.runVerify(reportsDirectory);
            }
        }
        catch (MojoExecutionException e) {
            thrown = e;
        }
        finally {
            if (!this.noWebapp) {
                try {
                    this.stopProducts(productExecutions);
                }
                catch (MojoExecutionException e) {
                    if (thrown == null) {
                        thrown = e;
                    }
                    thrown.addSuppressed((Throwable)e);
                }
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }

    @VisibleForTesting
    void populateProperties(Map<String, Object> systemProperties, String testGroupId, String pluginJar, List<String> instanceIds, Map<Integer, ProductExecution> productExecutionsByWebPort) {
        this.putIfNotOverridden(systemProperties, "plugin.jar", pluginJar);
        this.putIfNotOverridden(systemProperties, "testGroup", testGroupId);
        this.putIfNotOverridden(systemProperties, "testGroup.instanceIds", String.join((CharSequence)",", instanceIds));
        systemProperties.putAll(this.getTestGroupSystemProperties(testGroupId));
        for (Map.Entry<Integer, ProductExecution> entry : productExecutionsByWebPort.entrySet()) {
            Product product = entry.getValue().getProduct();
            ProductHandler productHandler = entry.getValue().getProductHandler();
            int webPort = entry.getKey();
            if (productExecutionsByWebPort.size() == 1) {
                this.putIfNotOverridden(systemProperties, "http.port", String.valueOf(webPort));
                this.putIfNotOverridden(systemProperties, "context.path", product.getContextPath());
            }
            String baseUrl = MavenGoals.getBaseUrl(product, webPort);
            this.putIfNotOverridden(systemProperties, "http." + product.getInstanceId() + ".port", String.valueOf(webPort));
            this.putIfNotOverridden(systemProperties, "context." + product.getInstanceId() + ".path", product.getContextPath());
            this.putIfNotOverridden(systemProperties, "http." + product.getInstanceId() + ".url", MavenGoals.getBaseUrl(product, webPort));
            this.putIfNotOverridden(systemProperties, "http." + product.getInstanceId() + ".protocol", product.getProtocol());
            this.putIfNotOverridden(systemProperties, "baseurl." + product.getInstanceId(), baseUrl);
            this.putIfNotOverridden(systemProperties, "baseurl", baseUrl);
            this.putIfNotOverridden(systemProperties, "homedir." + product.getInstanceId(), productHandler.getHomeDirectory(product).getAbsolutePath());
            this.putIfNotOverridden(systemProperties, "homedir", productHandler.getHomeDirectory(product).getAbsolutePath());
            this.putIfNotOverridden(systemProperties, "product." + product.getInstanceId() + ".id", product.getId());
            this.putIfNotOverridden(systemProperties, "product." + product.getInstanceId() + ".version", product.getVersion());
            systemProperties.putAll(this.getProductFunctionalTestProperties(product));
        }
    }

    private int setUpDebugging(int counter, Product product) {
        int newCounter = counter;
        if (product.getJvmDebugPort() == 0) {
            product.setJvmDebugPort(this.jvmDebugPort + newCounter++);
        }
        int debugPort = product.getJvmDebugPort();
        String debugArgs = " -Xdebug -Xrunjdwp:transport=dt_socket,address=" + debugPort + ",suspend=" + (this.jvmDebugSuspend ? "y" : "n") + ",server=y ";
        if (StringUtils.isBlank((CharSequence)product.getJvmArgs())) {
            product.setJvmArgs(StringUtils.trimToEmpty((String)this.jvmArgs));
        }
        product.setDebugArgs(debugArgs);
        return newCounter;
    }

    private void putIfNotOverridden(Map<String, Object> map, String key, Object value) {
        if (!map.containsKey(key)) {
            if (System.getProperties().containsKey(key)) {
                map.put(key, System.getProperty(key));
            } else {
                map.put(key, value);
            }
        }
    }

    private String getClassifier(String testGroupId) {
        for (TestGroup group : this.getTestGroups()) {
            if (!StringUtils.equals((CharSequence)group.getId(), (CharSequence)testGroupId)) continue;
            if (group.getClassifier() != null) {
                return group.getClassifier();
            }
            return "tomcat85x";
        }
        return "tomcat85x";
    }

    private Map<String, String> getTestGroupSystemProperties(String testGroupId) {
        if ("__no_test_group__".equals(testGroupId)) {
            return Collections.emptyMap();
        }
        for (TestGroup group : this.getTestGroups()) {
            if (!StringUtils.equals((CharSequence)group.getId(), (CharSequence)testGroupId)) continue;
            return group.getSystemProperties();
        }
        return Collections.emptyMap();
    }

    private List<String> getIncludesForTestGroup(String testGroupId) {
        if ("__no_test_group__".equals(testGroupId)) {
            return Collections.singletonList(this.functionalTestPattern);
        }
        for (TestGroup group : this.getTestGroups()) {
            if (!StringUtils.equals((CharSequence)group.getId(), (CharSequence)testGroupId)) continue;
            List<String> groupIncludes = group.getIncludes();
            if (groupIncludes.isEmpty()) {
                return Collections.singletonList(this.functionalTestPattern);
            }
            return groupIncludes;
        }
        return Collections.singletonList(this.functionalTestPattern);
    }

    private List<String> getExcludesForTestGroup(String testGroupId) {
        if ("__no_test_group__".equals(testGroupId)) {
            return Collections.emptyList();
        }
        for (TestGroup group : this.getTestGroups()) {
            if (!StringUtils.equals((CharSequence)group.getId(), (CharSequence)testGroupId)) continue;
            return group.getExcludes();
        }
        return Collections.emptyList();
    }
}

