/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.FeCruProductHandler;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;

public class ArtifactRetriever {
    private final ArtifactResolver artifactResolver;
    private final ArtifactFactory artifactFactory;
    private final ArtifactRepository localRepository;
    private final List<ArtifactRepository> remoteRepositories;
    private final RepositoryMetadataManager repositoryMetadataManager;

    public ArtifactRetriever(ArtifactResolver artifactResolver, ArtifactFactory artifactFactory, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, RepositoryMetadataManager repositoryMetadataManager) {
        this.artifactResolver = artifactResolver;
        this.artifactFactory = artifactFactory;
        this.localRepository = localRepository;
        this.remoteRepositories = remoteRepositories;
        this.repositoryMetadataManager = repositoryMetadataManager;
    }

    public String resolve(ProductArtifact dependency) throws MojoExecutionException {
        Artifact artifact = this.artifactFactory.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), "compile", "jar");
        try {
            this.artifactResolver.resolve(artifact, this.remoteRepositories, this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Cannot resolve artifact", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Cannot find artifact", (Exception)((Object)e));
        }
        return artifact.getFile().getPath();
    }

    public String getLatestStableVersion(Artifact artifact) throws MojoExecutionException {
        Object metadata = !artifact.isSnapshot() || "LATEST".equals(artifact.getBaseVersion()) || "RELEASE".equals(artifact.getBaseVersion()) ? new ArtifactRepositoryMetadata(artifact) : new SnapshotArtifactRepositoryMetadata(artifact);
        try {
            this.repositoryMetadataManager.resolve((RepositoryMetadata)metadata, this.remoteRepositories, this.localRepository);
            artifact.addMetadata((ArtifactMetadata)metadata);
            Metadata repoMetadata = metadata.getMetadata();
            String version = null;
            if (repoMetadata != null && repoMetadata.getVersioning() != null) {
                version = ArtifactRetriever.getLatestOfficialRelease(repoMetadata.getVersioning().getVersions(), artifact);
            }
            if (version == null) {
                version = artifact.getBaseVersion();
            }
            return version;
        }
        catch (RepositoryMetadataResolutionException e) {
            throw new MojoExecutionException("Error resolving stable version", (Exception)((Object)e));
        }
    }

    @Nullable
    @VisibleForTesting
    static String getLatestOfficialRelease(Collection<String> versions, Artifact artifact) {
        return versions.stream().map(DefaultArtifactVersion::new).filter(version -> ArtifactRetriever.isOfficialRelease((ArtifactVersion)version, artifact)).max(Comparable::compareTo).map(Object::toString).orElse(null);
    }

    private static boolean isOfficialRelease(ArtifactVersion version, Artifact artifact) {
        return StringUtils.isBlank((CharSequence)version.getQualifier()) || FeCruProductHandler.isFecruRelease(version, artifact);
    }
}

