/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.jira;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.product.jira.AbstractJiraOracleDatabase;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseOracle10gImpl;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import java.io.File;
import java.nio.charset.StandardCharsets;
import org.apache.maven.plugin.logging.Log;
import org.springframework.jdbc.core.JdbcTemplate;

public class JiraDatabaseOracle12cImpl
extends AbstractJiraOracleDatabase {
    public JiraDatabaseOracle12cImpl(DataSource dataSource, Log log) {
        super(dataSource, log);
    }

    @Override
    protected String getSqlToDropAndCreateUser() {
        if (this.oracleInStandaloneMode()) {
            return new JiraDatabaseOracle10gImpl(this.dataSource, this.log).getSqlToDropAndCreateUser();
        }
        return this.getTenantedModeDropAndCreateUserQuery();
    }

    private String getTenantedModeDropAndCreateUserQuery() {
        String dumpFileDirectoryPath = new File(this.dataSource.getDumpFilePath()).getParent();
        return FileUtils.readFileToString("oracle12c-template.sql", this.getClass(), StandardCharsets.UTF_8).replace("v_data_pump_dir", dumpFileDirectoryPath).replace("v_jira_user", this.dataSource.getUsername()).replace("v_jira_pwd", this.dataSource.getPassword());
    }

    private boolean oracleInStandaloneMode() {
        JdbcTemplate jdbcOperations = new JdbcTemplate(this.dataSource.getJdbcDataSource());
        String isCdb = (String)jdbcOperations.queryForObject("select cdb from v$database", String.class);
        return isCdb == null || isCdb.toLowerCase().startsWith("n");
    }
}

