/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.jira;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.product.ImportMethod;
import com.atlassian.maven.plugins.amps.product.jira.AbstractJiraDatabase;
import java.io.File;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class AbstractJiraOracleDatabase
extends AbstractJiraDatabase {
    protected static final String DATA_PUMP_DIR = "DATA_PUMP_DIR";
    private static final String ARGUMENT = "argument";

    protected AbstractJiraOracleDatabase(DataSource dataSource, Log log) {
        super(dataSource, log);
    }

    @Override
    protected String dropDatabase() {
        return null;
    }

    @Override
    protected String dropUser() {
        return null;
    }

    @Override
    protected String createDatabase() {
        return null;
    }

    @Override
    protected String createUser() {
        return null;
    }

    @Override
    protected String grantPermissionForUser() {
        return null;
    }

    @Override
    protected String getDatabaseName(String url) {
        return this.dataSource.getSchema();
    }

    @Override
    public Xpp3Dom getExecMavenToolImportConfiguration() throws MojoExecutionException {
        Xpp3Dom configDatabaseTool = null;
        if (ImportMethod.IMPDP.equals((Object)ImportMethod.getValueOf(this.dataSource.getImportMethod()))) {
            File dumpFile = new File(this.dataSource.getDumpFilePath());
            File dumpFileDirectory = dumpFile.getParentFile();
            String dumpFileName = dumpFile.getName();
            AbstractJiraOracleDatabase.setExecutableReadWrite(dumpFile);
            AbstractJiraOracleDatabase.setExecutableReadWrite(dumpFileDirectory);
            configDatabaseTool = MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("executable"), "impdp"), MojoExecutor.element(MojoExecutor.name("arguments"), MojoExecutor.element(MojoExecutor.name(ARGUMENT), this.dataSource.getUsername() + "/" + this.dataSource.getPassword()), MojoExecutor.element(MojoExecutor.name(ARGUMENT), "DUMPFILE=" + dumpFileName), MojoExecutor.element(MojoExecutor.name(ARGUMENT), "DIRECTORY=DATA_PUMP_DIR")));
        }
        return configDatabaseTool;
    }

    private static void setExecutableReadWrite(File file) throws MojoExecutionException {
        AbstractJiraOracleDatabase.ensure(file, f -> f.setExecutable(true, false));
        AbstractJiraOracleDatabase.ensure(file, f -> f.setReadable(true, false));
        AbstractJiraOracleDatabase.ensure(file, f -> f.setWritable(true, false));
    }

    private static void ensure(File file, Function<File, Boolean> action) throws MojoExecutionException {
        if (!Boolean.TRUE.equals(action.apply(file))) {
            throw new MojoExecutionException("Could not modify the file " + file.getAbsolutePath());
        }
    }

    @Override
    @Nonnull
    public Xpp3Dom getSqlMavenCreateConfiguration() {
        String sql = this.getSqlToDropAndCreateUser();
        this.log.info((CharSequence)("Oracle initialization database SQL: " + sql));
        Xpp3Dom sqlPluginConfiguration = this.systemDatabaseConfiguration();
        AbstractJiraOracleDatabase.addChild(sqlPluginConfiguration, "sqlCommand", sql);
        AbstractJiraOracleDatabase.addChild(sqlPluginConfiguration, "delimiter", "/");
        AbstractJiraOracleDatabase.addChild(sqlPluginConfiguration, "delimiterType", "row");
        AbstractJiraOracleDatabase.addChild(sqlPluginConfiguration, "driverProperties", this.dataSource.getSqlPluginJdbcDriverProperties());
        return sqlPluginConfiguration;
    }

    protected abstract String getSqlToDropAndCreateUser();

    private static void addChild(Xpp3Dom parentNode, String childName, String childValue) {
        parentNode.addChild(MojoExecutor.element(MojoExecutor.name(childName), childValue).toDom());
    }
}

