/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractProductHandler;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.atlassian.maven.plugins.amps.util.ZipUtils;
import com.atlassian.maven.plugins.amps.util.ant.AntJavaExecutorThread;
import com.atlassian.maven.plugins.amps.util.ant.JavaTaskFactory;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;

public class FeCruProductHandler
extends AbstractProductHandler {
    private static final int STARTUP_CHECK_DELAY = 1000;
    private static final String FISHEYE_INST = "fisheye.inst";
    private static final String PRODUCT_GROUP_ID = "com.atlassian.crucible";
    private static final String PRODUCT_ARTIFACT_ID = "atlassian-crucible";
    private static final String TEST_DATA_GROUP_ID = "com.atlassian.fecru";
    private static final String TEST_DATA_ARTIFACT_ID = "amps-fecru";
    private static final String FECRU_TIMESTAMP_FORMAT = "yyyyMMddHHmmss";
    private final JavaTaskFactory javaTaskFactory;

    public static boolean isFecruRelease(ArtifactVersion version, Artifact artifact) {
        return FeCruProductHandler.isFecruArtifact(artifact) && FeCruProductHandler.isFecruTimestamp(version.getQualifier());
    }

    private static boolean isFecruTimestamp(String qualifier) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(FECRU_TIMESTAMP_FORMAT);
        dateFormat.setLenient(false);
        Date releaseDate = ((DateFormat)dateFormat).parse(qualifier, new ParsePosition(0));
        return releaseDate != null;
    }

    public static boolean isFecruArtifact(Artifact artifact) {
        return FeCruProductHandler.isProductArtifact(artifact) || FeCruProductHandler.isTestResourcesArtifact(artifact);
    }

    public static boolean isProductArtifact(Artifact artifact) {
        return PRODUCT_GROUP_ID.equals(artifact.getGroupId()) && PRODUCT_ARTIFACT_ID.equals(artifact.getArtifactId());
    }

    public static boolean isTestResourcesArtifact(Artifact artifact) {
        return TEST_DATA_GROUP_ID.equals(artifact.getGroupId()) && TEST_DATA_ARTIFACT_ID.equals(artifact.getArtifactId());
    }

    public FeCruProductHandler(MavenContext context, MavenGoals goals, ArtifactFactory artifactFactory) {
        super(context, goals, new FeCruPluginProvider(), artifactFactory);
        this.javaTaskFactory = new JavaTaskFactory(this.log);
    }

    @Override
    public String getId() {
        return "fecru";
    }

    @Override
    public ProductArtifact getArtifact() {
        return new ProductArtifact(PRODUCT_GROUP_ID, PRODUCT_ARTIFACT_ID, "RELEASE");
    }

    @Override
    public int getDefaultHttpPort() {
        return 3990;
    }

    @Override
    public int getDefaultHttpsPort() {
        return 8443;
    }

    @Override
    public final void stop(Product ctx) throws MojoExecutionException {
        this.log.info((CharSequence)("Stopping " + ctx.getInstanceId() + " on ports " + ctx.getHttpPort() + " (http) and " + FeCruProductHandler.controlPort(ctx.getHttpPort()) + " (control)"));
        try {
            this.execFishEyeCmd("stop", ctx, false);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to stop FishEye/Crucible instance at " + ctx.getServer() + ":" + ctx.getHttpPort());
        }
        this.waitForFishEyeToStop(ctx);
    }

    @Override
    public List<ConfigFileUtils.Replacement> getReplacements(Product ctx) {
        List<ConfigFileUtils.Replacement> replacements = super.getReplacements(ctx);
        File homeDirectory = this.getHomeDirectory(ctx);
        replacements.add(new ConfigFileUtils.Replacement("@CONTROL_BIND@", String.valueOf(FeCruProductHandler.controlPort(ctx.getHttpPort()))));
        replacements.add(new ConfigFileUtils.Replacement("@HTTP_BIND@", String.valueOf(ctx.getHttpPort())));
        replacements.add(new ConfigFileUtils.Replacement("@HTTP_CONTEXT@", String.valueOf(ctx.getContextPath()), false));
        replacements.add(new ConfigFileUtils.Replacement("@HOME_DIR@", homeDirectory.getAbsolutePath()));
        replacements.add(new ConfigFileUtils.Replacement("@SITE_URL@", this.siteUrl(ctx)));
        return replacements;
    }

    @Override
    public List<File> getConfigFiles(Product product, File homeDir) {
        List<File> configFiles = super.getConfigFiles(product, homeDir);
        configFiles.add(new File(homeDir, "config.xml"));
        configFiles.add(new File(homeDir, "var/data/crudb/crucible.script"));
        return configFiles;
    }

    @Override
    protected File extractApplication(Product ctx, File homeDir) throws MojoExecutionException {
        File appDir = ProjectUtils.createDirectory(this.getAppDirectory(ctx));
        ProductArtifact defaults = this.getArtifact();
        ProductArtifact artifact = new ProductArtifact(ProjectUtils.firstNotNull(ctx.getGroupId(), defaults.getGroupId()), ProjectUtils.firstNotNull(ctx.getArtifactId(), defaults.getArtifactId()), ProjectUtils.firstNotNull(ctx.getVersion(), defaults.getVersion()));
        File cruDistZip = this.goals.copyDist(this.getBuildDirectory(), artifact);
        try {
            int nestingLevel = ZipUtils.countNestingLevel(cruDistZip);
            ZipUtils.unzip(cruDistZip, appDir.getPath(), nestingLevel > 0 ? 1 : 0);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to extract application ZIP artifact", (Exception)ex);
        }
        return appDir;
    }

    protected File getAppDirectory(Product ctx) {
        return new File(this.getBaseDirectory(ctx), ctx.getId() + "-" + ctx.getVersion());
    }

    @Override
    public final ProductArtifact getTestResourcesArtifact() {
        return new ProductArtifact(TEST_DATA_GROUP_ID, TEST_DATA_ARTIFACT_ID);
    }

    @Override
    protected Map<String, String> getSystemProperties(Product ctx) {
        return Collections.singletonMap(FISHEYE_INST, this.getHomeDirectory(ctx).getAbsolutePath());
    }

    @Override
    protected File getBundledPluginPath(Product ctx, File appDir) {
        return new File(appDir, "plugins/bundled-plugins.zip");
    }

    @Override
    protected Collection<? extends ProductArtifact> getDefaultBundledPlugins() {
        return Collections.emptySet();
    }

    @Override
    protected Collection<? extends ProductArtifact> getDefaultLibPlugins() {
        return Collections.emptySet();
    }

    @Override
    protected final File getUserInstalledPluginsDirectory(Product product, File appDir, File homeDir) {
        return new File(new File(new File(homeDir, "var"), "plugins"), "user");
    }

    @Override
    protected boolean supportsStaticPlugins() {
        return false;
    }

    @Override
    protected final int startApplication(Product ctx, File app, File homeDir, Map<String, String> properties) throws MojoExecutionException {
        AntJavaExecutorThread thread;
        this.log.info((CharSequence)("Starting " + ctx.getInstanceId() + " on ports " + ctx.getHttpPort() + " (http) and " + FeCruProductHandler.controlPort(ctx.getHttpPort()) + " (control)"));
        try {
            thread = this.execFishEyeCmd("run", ctx, true);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error starting fisheye.", e);
        }
        this.waitForFishEyeToStart(ctx, thread);
        return ctx.getHttpPort();
    }

    private void waitForFishEyeToStart(Product ctx, AntJavaExecutorThread thread) throws MojoExecutionException {
        boolean connected = false;
        int waited = 0;
        while (!connected) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                new Socket("localhost", ctx.getHttpPort()).close();
                connected = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (thread.isFinished()) {
                throw new MojoExecutionException("Fisheye failed to start.", (Exception)thread.getBuildException());
            }
            if (waited++ * 1000 <= ctx.getStartupTimeout()) continue;
            throw new MojoExecutionException("FishEye took longer than " + ctx.getStartupTimeout() + "ms to start!");
        }
    }

    private void waitForFishEyeToStop(Product ctx) throws MojoExecutionException {
        boolean connected = true;
        int waited = 0;
        while (connected) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                new Socket("localhost", ctx.getHttpPort()).close();
            }
            catch (IOException e) {
                connected = false;
            }
            if (waited++ * 1000 <= ctx.getShutdownTimeout()) continue;
            throw new MojoExecutionException("FishEye took longer than " + ctx.getShutdownTimeout() + "ms to stop!");
        }
    }

    private AntJavaExecutorThread execFishEyeCmd(String bootCommand, Product product, boolean useDebugArgs) {
        Map<String, String> properties = this.mergeSystemProperties(product);
        Java java = this.javaTaskFactory.newJavaTask(JavaTaskFactory.output(product.getOutput()).systemProperties(properties).jvmArgs(product.getJvmArgs() + (useDebugArgs ? product.getDebugArgs() : "")));
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(new File(this.getAppDirectory(product), "fisheyeboot.jar"));
        java.setClassname("com.cenqua.fisheye.FishEyeCtl");
        java.createArg().setValue(bootCommand);
        AntJavaExecutorThread javaThread = new AntJavaExecutorThread(java);
        javaThread.start();
        return javaThread;
    }

    protected File getBuildDirectory() {
        return new File(this.project.getBuild().getDirectory());
    }

    private String siteUrl(Product ctx) {
        return "http://" + ctx.getServer() + ":" + ctx.getHttpPort() + ctx.getContextPath();
    }

    public static int controlPort(int httpPort) {
        return httpPort * 10 + 1;
    }

    @Override
    public void cleanupProductHomeForZip(Product product, File homeDirectory) throws MojoExecutionException, IOException {
        super.cleanupProductHomeForZip(product, homeDirectory);
        FileUtils.deleteQuietly((File)new File(homeDirectory, "var/log"));
        FileUtils.deleteQuietly((File)new File(homeDirectory, "var/plugins"));
        FileUtils.deleteQuietly((File)new File(homeDirectory, "cache/plugins"));
    }

    @Override
    protected String getLibArtifactTargetDir() {
        return "lib";
    }

    @Override
    protected File getRootDir(File tmpDir, Product product) throws IOException {
        File[] topLevelFiles = Optional.ofNullable(tmpDir.listFiles()).orElse(new File[0]);
        if (topLevelFiles.length == 1) {
            return topLevelFiles[0];
        }
        this.log.info((CharSequence)"Non-standard zip structure identified. Assume using older non-standard FECRU zip format");
        this.log.info((CharSequence)"Therefore reorganise unpacked data directories to match standard format.");
        File tmpGen = new File(tmpDir, "generated-resources");
        File tmpHome = new File(tmpGen, product.getId() + "-home");
        for (File file : topLevelFiles) {
            FileUtils.moveToDirectory((File)file, (File)tmpHome, (boolean)true);
        }
        return tmpGen;
    }

    private static class FeCruPluginProvider
    extends AbstractPluginProvider {
        private FeCruPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-fisheye-plugin", salVersion));
        }
    }
}

