/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractProductHandler;
import com.atlassian.maven.plugins.amps.product.PluginProvider;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public abstract class AbstractWebappProductHandler
extends AbstractProductHandler {
    private static final String CARGO_CONTAINER_ID_PROPERTY = "amps.product.specific.cargo.container";
    private static final String SPECIFIC_CONTAINER_PROPERTY = "amps.product.specific.container";

    public AbstractWebappProductHandler(MavenContext context, MavenGoals goals, PluginProvider pluginProvider, ArtifactFactory artifactFactory) {
        super(context, goals, pluginProvider, artifactFactory);
    }

    @Override
    public final void stop(Product ctx) throws MojoExecutionException {
        this.goals.stopWebapp(ctx.getInstanceId(), ctx.getContainerId(), ctx);
    }

    @Override
    protected final File extractApplication(Product ctx, File homeDir) throws MojoExecutionException {
        ProductArtifact defaults = this.getArtifact();
        ProductArtifact artifact = new ProductArtifact(ProjectUtils.firstNotNull(ctx.getGroupId(), defaults.getGroupId()), ProjectUtils.firstNotNull(ctx.getArtifactId(), defaults.getArtifactId()), ProjectUtils.firstNotNull(ctx.getVersion(), defaults.getVersion()));
        if ("RELEASE".equals(artifact.getVersion()) || "LATEST".equals(artifact.getVersion())) {
            this.log.info((CharSequence)"determining latest stable product version...");
            Artifact warArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            String stableVersion = ctx.getArtifactRetriever().getLatestStableVersion(warArtifact);
            this.log.info((CharSequence)("using latest stable product version: " + stableVersion));
            artifact.setVersion(stableVersion);
            ctx.setVersion(stableVersion);
        }
        return this.goals.copyWebappWar(ctx.getId(), this.getBaseDirectory(ctx), artifact);
    }

    @Override
    protected final int startApplication(Product ctx, File app, File homeDir, Map<String, String> properties) throws MojoExecutionException {
        return this.goals.startWebapp(app, properties, this.getExtraContainerDependencies(), this.getExtraProductDeployables(ctx), ctx);
    }

    @Override
    protected boolean supportsStaticPlugins() {
        return true;
    }

    @Override
    protected String getLog4jPropertiesPath() {
        return "WEB-INF/classes/log4j.properties";
    }

    protected abstract List<ProductArtifact> getExtraContainerDependencies();

    protected List<ProductArtifact> getExtraProductDeployables(Product ctx) {
        return Collections.emptyList();
    }

    @Override
    protected Map<String, String> getSystemProperties(Product ctx) {
        return this.generateDataSourceSystemProperties(ctx);
    }

    protected Map<String, String> generateDataSourceSystemProperties(Product product) {
        List<DataSource> dataSources = this.getDataSources(product);
        if (dataSources.size() == 1) {
            return Collections.singletonMap("cargo.datasource.datasource", dataSources.get(0).getCargoString());
        }
        ImmutableMap.Builder systemProperties = ImmutableMap.builder();
        for (int i = 0; i < dataSources.size(); ++i) {
            systemProperties.put((Object)("cargo.datasource.datasource." + i), (Object)dataSources.get(i).getCargoString());
        }
        return systemProperties.build();
    }

    private List<DataSource> getDataSources(Product product) {
        List<DataSource> dataSources = product.getDataSources();
        DataSource defaultDataSource = this.getDefaultDataSource(product);
        if (defaultDataSource != null) {
            if (dataSources.isEmpty()) {
                dataSources.add(defaultDataSource);
            } else {
                dataSources.get(0).useForUnsetValues(defaultDataSource);
            }
        }
        return dataSources;
    }

    @Nullable
    protected DataSource getDefaultDataSource(Product ctx) {
        return null;
    }

    @Override
    protected void addOverridesFromProductPom(Product ctx) throws MojoExecutionException {
        ProductArtifact defaults = this.getArtifact();
        ProductArtifact artifact = new ProductArtifact(ProjectUtils.firstNotNull(ctx.getGroupId(), defaults.getGroupId()), ProjectUtils.firstNotNull(ctx.getArtifactId(), defaults.getArtifactId()), ProjectUtils.firstNotNull(ctx.getVersion(), defaults.getVersion()));
        File effectivePom = this.goals.generateEffectivePom(artifact, this.getBaseDirectory(ctx));
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(effectivePom.getAbsoluteFile());
            Element properties = document.getRootElement().element("properties");
            if (properties != null) {
                Element customContainer = properties.element(SPECIFIC_CONTAINER_PROPERTY);
                Element cargoId = properties.element(CARGO_CONTAINER_ID_PROPERTY);
                this.setPropertiesInProduct(ctx, customContainer, cargoId);
            }
        }
        catch (DocumentException e) {
            this.log.error((CharSequence)"Error when reading effective pom", (Throwable)e);
        }
    }

    private void setPropertiesInProduct(Product ctx, Element customContainer, Element cargoId) {
        if (customContainer != null && ctx.getCustomContainerArtifact() == null && ctx.isContainerNotSpecified()) {
            ctx.setCustomContainerArtifact(customContainer.getStringValue());
            if (cargoId != null) {
                ctx.setContainerId(cargoId.getStringValue());
            }
        }
    }
}

