/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerMojo;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.locator.DefaultModelLocator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="run-standalone", requiresProject=false)
public class RunStandaloneMojo
extends AbstractProductHandlerMojo {
    private static final String GROUP_ID = "com.atlassian.amps";
    private static final String ARTIFACT_ID = "standalone";
    private static final String AMPS_FECRU_URL = "https://packages.atlassian.com/content/repositories/atlassian-public/com/atlassian/fecru/amps-fecru/";
    @Component
    private ProjectBuilder projectBuilder;

    private Artifact getStandaloneArtifact() {
        String version = this.getPluginInformation().getVersion();
        return this.artifactFactory.createProjectArtifact(GROUP_ID, ARTIFACT_ID, version);
    }

    protected String getAmpsGoal() {
        return "run";
    }

    @Override
    protected void doExecute() throws MojoExecutionException {
        this.getUpdateChecker().check();
        this.trackFirstRunIfNeeded();
        this.getGoogleTracker().track("Run Standalone");
        try {
            MavenGoals goals = this.createMavenGoals(this.projectBuilder);
            PluginManagement mgmt = goals.getContextProject().getBuild().getPluginManagement();
            Plugin plugin = (Plugin)mgmt.getPluginsAsMap().get("com.atlassian.maven.plugins:amps-maven-plugin");
            Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
            goals.executeAmpsRecursively(this.getPluginInformation().getVersion(), this.getAmpsGoal(), configuration);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected MavenGoals createMavenGoals(ProjectBuilder projectBuilder) throws ProjectBuildingException, IOException {
        MavenContext oldContext = this.getMavenContext();
        MavenSession oldSession = oldContext.getSession();
        Properties systemProperties = oldSession.getSystemProperties();
        String product = this.getPropertyOrDefault(systemProperties, "product", "refapp");
        String productVersion = this.getPropertyOrDefault(systemProperties, "product.version", "LATEST");
        if (product.equals("fecru") && !"LATEST".equals(productVersion) && !Pattern.matches(".*[0-9]{14}$", productVersion)) {
            String fullProductVersionMessage = this.getFullVersion(productVersion).map(version -> this.generateFullVersionMessage(productVersion, (String)version)).orElseGet(() -> this.generateNoVersionMessage(productVersion));
            this.getLog().error((CharSequence)"=======================================================================");
            this.getLog().error((CharSequence)fullProductVersionMessage);
            this.getLog().error((CharSequence)"=======================================================================");
            System.exit(1);
        }
        File base = new File("amps-standalone-" + product + "-" + productVersion).getAbsoluteFile();
        ProjectBuildingRequest pbr = oldSession.getProjectBuildingRequest();
        pbr.setRemoteRepositories(oldSession.getCurrentProject().getRemoteArtifactRepositories());
        pbr.setPluginArtifactRepositories(oldSession.getCurrentProject().getPluginArtifactRepositories());
        pbr.getSystemProperties().setProperty("project.basedir", base.getPath());
        ProjectBuildingResult result = projectBuilder.build(this.getStandaloneArtifact(), false, pbr);
        List<MavenProject> newReactor = Collections.singletonList(result.getProject());
        MavenSession newSession = oldSession.clone();
        newSession.setProjects(newReactor);
        result.getProject().setFile(new DefaultModelLocator().locatePom(base));
        MavenContext newContext = oldContext.with(result.getProject(), newReactor, newSession);
        return new MavenGoals(newContext, this.mojoExecutorWrapper);
    }

    private String generateNoVersionMessage(String productVersion) {
        return "There is no valid full version of " + productVersion + ". Please double check your input\n\tThe full list of versions can be found at: \n\thttps://packages.atlassian.com/content/repositories/atlassian-public/com/atlassian/fecru/amps-fecru/";
    }

    private String generateFullVersionMessage(String productVersion, String version) {
        return "You entered: " + productVersion + " as your version, this is not a version.\n\tDid you mean?: " + version + "\n\tPlease re-run with the correct version (atlas-run-standalone --product fecru -v " + version + ")";
    }

    protected Optional<String> getFullVersion(String versionInput) throws IOException {
        Pattern p = Pattern.compile(".*>(" + versionInput + "-[0-9]{14}).*");
        String correctVersion = null;
        URLConnection connection = new URL(AMPS_FECRU_URL).openConnection();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                Matcher m = p.matcher(inputLine);
                if (!m.matches()) continue;
                correctVersion = m.group(1);
            }
        }
        return Optional.ofNullable(correctVersion);
    }

    private String getPropertyOrDefault(Properties systemProperties, String property, String defaultValue) {
        String value = systemProperties.getProperty(property);
        return value == null ? defaultValue : value;
    }
}

