/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.product.common.XMLDocumentHandler;
import com.atlassian.maven.plugins.amps.product.common.XMLDocumentProcessor;
import com.atlassian.maven.plugins.amps.product.common.XMLDocumentTransformer;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.dom4j.Element;
import org.dom4j.Node;

public class ConfluenceLicenseConfigurer {
    private static final String LICENSE_PROPERTY = "atlassian.license.message";

    public void configure(File configFile, String license) throws MojoExecutionException {
        if (StringUtils.isBlank((CharSequence)license)) {
            throw new IllegalArgumentException(String.format("Invalid license '%s'", license));
        }
        new XMLDocumentProcessor(new XMLDocumentHandler(configFile)).load().transform(this.setLicense(license)).saveIfModified();
    }

    private XMLDocumentTransformer setLicense(String license) {
        return document -> {
            Element rootElement = document.getRootElement();
            Node licenseNode = rootElement.selectSingleNode(this.licenseProperty());
            if (licenseNode == null) {
                throw new UnsupportedOperationException("Could not find property called atlassian.license.message");
            }
            if (license.equals(licenseNode.getText())) {
                return false;
            }
            licenseNode.setText(StringUtils.remove((String)license, (char)' '));
            return true;
        };
    }

    private String licenseProperty() {
        return String.format("//property[@name='%s']", LICENSE_PROPERTY);
    }
}

