/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractTestGroupsHandlerMojo;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Node;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.TestGroup;
import com.atlassian.maven.plugins.amps.util.DebugUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="integration-test", requiresDependencyResolution=ResolutionScope.TEST)
public class IntegrationTestMojo
extends AbstractTestGroupsHandlerMojo {
    @VisibleForTesting
    @Parameter(property="functional.test.pattern")
    String functionalTestPattern = "%regex[it[/\\\\].*]";
    @Parameter(property="project.build.testOutputDirectory", required=true)
    private File testClassesDirectory;
    @Parameter(property="testGroups")
    private String configuredTestGroupsToRun;
    @Parameter(property="no.webapp", defaultValue="false")
    private boolean noWebapp;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean testsSkip;
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="skipITs", defaultValue="false")
    private boolean skipITs;
    @Parameter(property="jvm.debug.port", defaultValue="0")
    protected int jvmDebugPort;
    @Parameter(property="jvm.debug.suspend")
    protected boolean jvmDebugSuspend;
    @Parameter(property="maven.failsafe.debug")
    protected String mavenFailsafeDebug;
    @Parameter
    protected String category;
    @Parameter(property="skip.IT.verification")
    protected boolean skipITVerification;

    @Override
    protected void doExecute() throws MojoExecutionException {
        if (!new File(this.testClassesDirectory, "it").exists()) {
            this.getLog().info((CharSequence)"No integration tests found");
            return;
        }
        if (this.skipTests || this.testsSkip || this.skipITs) {
            this.getLog().info((CharSequence)"Integration tests skipped");
            return;
        }
        MavenProject project = this.getMavenContext().getProject();
        project.getArtifact().setArtifactHandler(this.artifactHandlerManager.getArtifactHandler("jar"));
        MavenGoals goals = this.getMavenGoals();
        String pluginJar = this.targetDirectory.getAbsolutePath() + "/" + this.finalName + ".jar";
        for (String testGroupId : this.getTestGroupsToRun()) {
            this.runTestsForTestGroup(testGroupId, goals, pluginJar, IntegrationTestMojo.copy(this.systemPropertyVariables));
        }
    }

    private Collection<String> getTestGroupsToRun() {
        Set<String> superclassTestGroupIds = this.getTestGroupIds();
        if (superclassTestGroupIds.isEmpty()) {
            return Collections.singleton("__no_test_group__");
        }
        if (this.configuredTestGroupsToRun == null) {
            return superclassTestGroupIds;
        }
        HashSet<String> testGroupIdsInCommonWithSuperclass = new HashSet<String>();
        for (String testGroupId : this.configuredTestGroupsToRun.split(",")) {
            if (superclassTestGroupIds.contains(testGroupId)) {
                testGroupIdsInCommonWithSuperclass.add(testGroupId);
                continue;
            }
            this.getLog().warn((CharSequence)("Test group '" + testGroupId + "' does not exist"));
        }
        return testGroupIdsInCommonWithSuperclass;
    }

    private static Map<String, Object> copy(Map<String, Object> mapIn) {
        return new HashMap<String, Object>(mapIn);
    }

    protected Map<String, String> getProductFunctionalTestProperties(Product product) {
        return Collections.emptyMap();
    }

    private boolean debuggingEnabled() {
        return this.jvmDebugPort > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestsForTestGroup(String testGroupId, MavenGoals goals, String pluginJar, Map<String, Object> systemProperties) throws MojoExecutionException {
        List<String> includes = this.getIncludesForTestGroup(testGroupId);
        List<String> excludes = this.getExcludesForTestGroup(testGroupId);
        List<Product> products = this.getProductsForTestGroup(testGroupId);
        this.setParallelMode(products);
        if (this.debuggingEnabled()) {
            DebugUtils.setNodeDebugPorts(products, this.jvmDebugPort);
        }
        Map<Integer, Product> productsByNodeWebPort = this.start(products);
        this.populateNonProductProperties(systemProperties, testGroupId, pluginJar, products);
        this.populateProductProperties(systemProperties, productsByNodeWebPort);
        if (!this.noWebapp) {
            this.waitForProducts(products, true);
        }
        MojoExecutionException thrown = null;
        try {
            this.doRunTests(testGroupId, goals, systemProperties, includes, excludes);
        }
        catch (MojoExecutionException e) {
            thrown = e;
        }
        finally {
            if (!this.noWebapp) {
                try {
                    this.stopProducts(products);
                }
                catch (MojoExecutionException e) {
                    if (thrown == null) {
                        thrown = e;
                    }
                    thrown.addSuppressed((Throwable)e);
                }
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }

    private Map<Integer, Product> start(Iterable<Product> products) throws MojoExecutionException {
        HashMap<Integer, Product> productsByNodeWebPort = new HashMap<Integer, Product>();
        for (Product product : products) {
            if (product.isInstallPlugin() == null) {
                product.setInstallPlugin(this.installPlugin);
            }
            if (this.shouldBuildTestPlugin()) {
                product.addBundledArtifacts(this.getTestFrameworkPlugins());
            }
            List<Node> nodes = this.startIfNecessary(product);
            for (Node node : nodes) {
                int webPort = node.getWebPort();
                if (productsByNodeWebPort.put(webPort, product) == null) continue;
                throw new MojoExecutionException(String.format("HTTP server port %d was already occupied", webPort));
            }
        }
        return productsByNodeWebPort;
    }

    private List<Node> startIfNecessary(Product product) throws MojoExecutionException {
        List<Node> nodes;
        if (this.noWebapp) {
            nodes = product.getNodes();
            this.validateWebPortsSet(nodes, product.getProtocol());
        } else {
            if (this.debuggingEnabled()) {
                product.defaultJvmArgs(this.jvmArgs);
                product.setNodeDebugArgs(this.jvmDebugSuspend, this.getLog());
            }
            nodes = this.getProductHandler(product.getId()).start(product);
        }
        return nodes;
    }

    private void doRunTests(String testGroupId, MavenGoals goals, Map<String, Object> systemProperties, List<String> includes, List<String> excludes) throws MojoExecutionException {
        String reportsDirectory = MavenGoals.getReportsDirectory(this.targetDirectory, "group-" + testGroupId, this.getClassifier(testGroupId));
        goals.runIntegrationTests(reportsDirectory, includes, excludes, systemProperties, this.category, this.mavenFailsafeDebug);
        if (this.skipITVerification) {
            this.getLog().info((CharSequence)"Skipping failsafe IT failure verification.");
        } else {
            goals.runVerify(reportsDirectory);
        }
    }

    private void validateWebPortsSet(Collection<Node> nodes, String protocol) throws MojoExecutionException {
        for (Node node : nodes) {
            if (node.getWebPort() > 0) continue;
            String portsWord = nodes.size() == 1 ? "port" : "ports";
            throw new MojoExecutionException(String.format("%s %s must be set when using the no.webapp flag.", protocol, portsWord));
        }
    }

    @VisibleForTesting
    void populateProductProperties(Map<String, Object> systemProperties, Map<Integer, Product> productsByNodeWebPort) {
        for (Map.Entry<Integer, Product> entry : productsByNodeWebPort.entrySet()) {
            int nodeWebPort = entry.getKey();
            Product product = entry.getValue();
            if (productsByNodeWebPort.size() == 1) {
                IntegrationTestMojo.putIfNotOverridden(systemProperties, "http.port", String.valueOf(nodeWebPort));
                IntegrationTestMojo.putIfNotOverridden(systemProperties, "context.path", product.getContextPath());
            }
            String baseUrl = product.getBaseUrlForPort(nodeWebPort);
            IntegrationTestMojo.putIfNotOverridden(systemProperties, "http." + product.getInstanceId() + ".port", String.valueOf(nodeWebPort));
            IntegrationTestMojo.putIfNotOverridden(systemProperties, "context." + product.getInstanceId() + ".path", product.getContextPath());
            IntegrationTestMojo.putIfNotOverridden(systemProperties, "http." + product.getInstanceId() + ".url", baseUrl);
            IntegrationTestMojo.putIfNotOverridden(systemProperties, "http." + product.getInstanceId() + ".protocol", product.getProtocol());
            IntegrationTestMojo.putIfNotOverridden(systemProperties, "baseurl." + product.getInstanceId(), baseUrl);
            IntegrationTestMojo.putIfNotOverridden(systemProperties, "baseurl", baseUrl);
            this.putHomeDirProperties(product, systemProperties);
            IntegrationTestMojo.putIfNotOverridden(systemProperties, "product." + product.getInstanceId() + ".id", product.getId());
            IntegrationTestMojo.putIfNotOverridden(systemProperties, "product." + product.getInstanceId() + ".version", product.getVersion());
            systemProperties.putAll(this.getProductFunctionalTestProperties(product));
        }
    }

    private void populateNonProductProperties(Map<String, Object> systemProperties, String testGroupId, String pluginJar, Collection<Product> products) {
        String instanceIds = products.stream().map(Product::getInstanceId).collect(Collectors.joining(","));
        IntegrationTestMojo.putIfNotOverridden(systemProperties, "plugin.jar", pluginJar);
        IntegrationTestMojo.putIfNotOverridden(systemProperties, "testGroup", testGroupId);
        IntegrationTestMojo.putIfNotOverridden(systemProperties, "testGroup.instanceIds", instanceIds);
        systemProperties.putAll(this.getTestGroupSystemProperties(testGroupId));
    }

    private void putHomeDirProperties(Product product, Map<String, Object> properties) {
        List<File> homeDirectories = this.getProductHandler(product.getId()).getHomeDirectories(product);
        for (int i = 0; i < homeDirectories.size(); ++i) {
            String homeDirectory = homeDirectories.get(i).getAbsolutePath();
            if (i == 0) {
                IntegrationTestMojo.putIfNotOverridden(properties, "homedir", homeDirectory);
                IntegrationTestMojo.putIfNotOverridden(properties, "homedir." + product.getInstanceId(), homeDirectory);
            }
            String propertySuffix = "." + i;
            IntegrationTestMojo.putIfNotOverridden(properties, "homedir" + propertySuffix, homeDirectory);
            IntegrationTestMojo.putIfNotOverridden(properties, "homedir." + product.getInstanceId() + propertySuffix, homeDirectory);
        }
    }

    private static void putIfNotOverridden(Map<String, Object> map, String key, Object value) {
        map.computeIfAbsent(key, aKey -> System.getProperty(aKey, String.valueOf(value)));
    }

    private String getClassifier(String testGroupId) {
        for (TestGroup group : this.getTestGroups()) {
            if (!StringUtils.equals((CharSequence)group.getId(), (CharSequence)testGroupId)) continue;
            if (group.getClassifier() != null) {
                return group.getClassifier();
            }
            return "tomcat85x";
        }
        return "tomcat85x";
    }

    private Map<String, String> getTestGroupSystemProperties(String testGroupId) {
        if ("__no_test_group__".equals(testGroupId)) {
            return Collections.emptyMap();
        }
        for (TestGroup group : this.getTestGroups()) {
            if (!StringUtils.equals((CharSequence)group.getId(), (CharSequence)testGroupId)) continue;
            return group.getSystemProperties();
        }
        return Collections.emptyMap();
    }

    @VisibleForTesting
    List<String> getIncludesForTestGroup(String testGroupId) {
        if ("__no_test_group__".equals(testGroupId)) {
            return Collections.singletonList(this.functionalTestPattern);
        }
        for (TestGroup group : this.getTestGroups()) {
            if (!StringUtils.equals((CharSequence)group.getId(), (CharSequence)testGroupId)) continue;
            List<String> groupIncludes = group.getIncludes();
            if (groupIncludes.isEmpty()) {
                return Collections.singletonList(this.functionalTestPattern);
            }
            return groupIncludes;
        }
        return Collections.singletonList(this.functionalTestPattern);
    }

    private List<String> getExcludesForTestGroup(String testGroupId) {
        if ("__no_test_group__".equals(testGroupId)) {
            return Collections.emptyList();
        }
        for (TestGroup group : this.getTestGroups()) {
            if (!StringUtils.equals((CharSequence)group.getId(), (CharSequence)testGroupId)) continue;
            return group.getExcludes();
        }
        return Collections.emptyList();
    }
}

