/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.LibArtifact;
import com.atlassian.maven.plugins.amps.util.PropertyUtils;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.jdbc.support.DatabaseMetaDataCallback;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;

public class DataSource {
    private static final String[] FIELDS_TO_EXCLUDE_FROM_TO_STRING = new String[]{"password", "systemPassword"};
    private static final char PROPERTY_DELIMITER = ';';
    private static final char PROPERTY_KEY_VALUE_DELIMITER = '=';
    private String url;
    private String schema;
    private String driver;
    private String username;
    private String password;
    private String jndi;
    private String type;
    private String transactionSupport;
    private String properties;
    private String cargoString;
    private List<LibArtifact> libArtifacts = new ArrayList<LibArtifact>();
    private String defaultDatabase;
    private String systemUsername;
    private String systemPassword;
    private String dumpFilePath;
    private String importMethod = "sql";
    private boolean dropAndReCreateDatabase;
    private String validationQuery;

    public boolean isDropAndReCreateDatabase() {
        return this.dropAndReCreateDatabase;
    }

    public String getCargoString() {
        if (this.cargoString != null) {
            return this.cargoString;
        }
        ArrayList<String> cargoProperties = new ArrayList<String>();
        cargoProperties.add("cargo.datasource.url=" + (String)MoreObjects.firstNonNull((Object)this.url, (Object)""));
        cargoProperties.add("cargo.datasource.driver=" + (String)MoreObjects.firstNonNull((Object)this.driver, (Object)""));
        cargoProperties.add("cargo.datasource.username=" + (String)MoreObjects.firstNonNull((Object)this.username, (Object)""));
        cargoProperties.add("cargo.datasource.password=" + (String)MoreObjects.firstNonNull((Object)this.password, (Object)""));
        cargoProperties.add("cargo.datasource.jndi=" + (String)MoreObjects.firstNonNull((Object)this.jndi, (Object)""));
        if (!StringUtils.isBlank((CharSequence)this.type)) {
            cargoProperties.add("cargo.datasource.type=" + this.type);
        }
        if (!StringUtils.isBlank((CharSequence)this.transactionSupport)) {
            cargoProperties.add("cargo.datasource.transactionsupport=" + this.transactionSupport);
        }
        if (!StringUtils.isBlank((CharSequence)this.properties)) {
            cargoProperties.add("cargo.datasource.properties=" + this.properties);
        }
        this.cargoString = StringUtils.join(cargoProperties, (String)"|");
        return this.cargoString;
    }

    public void copyMissingValuesFrom(DataSource defaultValues) {
        if (this.jndi == null) {
            this.jndi = defaultValues.jndi;
        }
        if (this.url == null) {
            this.url = defaultValues.url;
        }
        if (this.schema == null) {
            this.schema = defaultValues.schema;
        }
        if (this.driver == null) {
            this.driver = defaultValues.driver;
        }
        if (this.username == null) {
            this.username = defaultValues.username;
        }
        if (this.password == null) {
            this.password = defaultValues.password;
        }
        if (this.type == null) {
            this.type = defaultValues.type;
        }
        if (this.transactionSupport == null) {
            this.transactionSupport = defaultValues.transactionSupport;
        }
        if (this.properties == null) {
            this.properties = defaultValues.properties;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getJndi() {
        return this.jndi;
    }

    public void setJndi(String jndi) {
        this.jndi = jndi;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTransactionSupport() {
        return this.transactionSupport;
    }

    public void setTransactionSupport(String transactionSupport) {
        this.transactionSupport = transactionSupport;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public List<LibArtifact> getLibArtifacts() {
        return this.libArtifacts;
    }

    public void setLibArtifacts(List<LibArtifact> libArtifacts) {
        this.libArtifacts = libArtifacts;
    }

    public void setCargoString(String cargoString) {
        this.cargoString = cargoString;
    }

    public String getSystemUrl() {
        return this.defaultDatabase;
    }

    public void setSystemUrl(String jdbcUrl) {
        this.defaultDatabase = jdbcUrl;
    }

    public String getSystemUsername() {
        return this.systemUsername;
    }

    public void setSystemUsername(String systemUsername) {
        this.systemUsername = systemUsername;
    }

    public String getSystemPassword() {
        return this.systemPassword;
    }

    public void setSystemPassword(String systemPassword) {
        this.systemPassword = systemPassword;
    }

    public String getDumpFilePath() {
        return this.dumpFilePath;
    }

    public void setDumpFilePath(String dumpFilePath) {
        this.dumpFilePath = dumpFilePath;
    }

    public String getImportMethod() {
        return this.importMethod;
    }

    public void setImportMethod(String importMethod) {
        this.importMethod = importMethod;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).setExcludeFieldNames(FIELDS_TO_EXCLUDE_FROM_TO_STRING).toString();
    }

    public javax.sql.DataSource getJdbcDataSource() {
        DriverManagerDataSource dataSource = new DriverManagerDataSource(this.defaultDatabase, this.systemUsername, this.systemPassword);
        dataSource.setConnectionProperties(PropertyUtils.parse(this.properties, '=', ';'));
        return dataSource;
    }

    @Nonnull
    public <T> Optional<T> getJdbcMetaData(@Nonnull DatabaseMetaDataCallback callback) {
        try {
            Object metaData = JdbcUtils.extractDatabaseMetaData((javax.sql.DataSource)this.getJdbcDataSource(), (DatabaseMetaDataCallback)callback);
            return Optional.ofNullable(metaData);
        }
        catch (ClassCastException | MetaDataAccessException e) {
            return Optional.empty();
        }
    }

    public void addProperty(String name, String value) {
        String newProperty = name + '=' + value;
        this.properties = StringUtils.isBlank((CharSequence)this.properties) ? newProperty : this.properties + ';' + newProperty;
    }

    public String getSqlPluginJdbcDriverProperties() {
        return StringUtils.trimToEmpty((String)this.properties).replace(';', ',');
    }

    @Nullable
    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }
}

