/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AmpsProductHandler;
import com.atlassian.maven.plugins.amps.product.ApplicationMapper;
import com.atlassian.maven.plugins.amps.product.GroupArtifactPair;
import com.atlassian.maven.plugins.amps.product.PluginProvider;
import com.atlassian.maven.plugins.amps.product.ProductContainerVersionMapper;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import com.atlassian.maven.plugins.amps.util.JvmArgsFix;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.atlassian.maven.plugins.amps.util.ZipUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public abstract class AbstractProductHandler
extends AmpsProductHandler {
    private static final Map<String, Map<String, GroupArtifactPair>> APPLICATION_KEYS = ImmutableMap.of((Object)"jira", (Object)ImmutableMap.of((Object)"jira-software", (Object)new GroupArtifactPair("com.atlassian.jira", "jira-software-application"), (Object)"jira-servicedesk", (Object)new GroupArtifactPair("com.atlassian.servicedesk", "jira-servicedesk-application")));
    private final PluginProvider pluginProvider;
    private final ApplicationMapper applicationMapper;

    protected AbstractProductHandler(MavenContext context, MavenGoals goals, PluginProvider pluginProvider, ArtifactFactory artifactFactory) {
        super(context, goals, artifactFactory);
        this.pluginProvider = pluginProvider;
        this.applicationMapper = new ApplicationMapper(APPLICATION_KEYS);
    }

    @Override
    public final int start(Product ctx) throws MojoExecutionException {
        File homeDir = this.extractAndProcessHomeDirectory(ctx);
        File extractedApp = this.extractApplication(ctx, homeDir);
        File finalApp = this.addArtifactsAndOverrides(ctx, homeDir, extractedApp);
        this.addOverridesFromProductPom(ctx);
        Map<String, String> systemProperties = this.mergeSystemProperties(ctx);
        return this.startApplication(ctx, finalApp, homeDir, systemProperties);
    }

    protected void addOverridesFromProductPom(Product ctx) throws MojoExecutionException {
    }

    @Override
    public String getDefaultContainerId(Product product) throws MojoExecutionException {
        return ProductContainerVersionMapper.containerForProductVersion(this.getId(), this.resolveVersion(product));
    }

    private String resolveVersion(Product product) throws MojoExecutionException {
        String version = product.getVersion();
        if (StringUtils.isBlank((CharSequence)version)) {
            version = "RELEASE";
        }
        if ("RELEASE".equals(version) || "LATEST".equals(version)) {
            ProductArtifact productArtifact = this.getArtifact();
            Artifact warArtifact = this.artifactFactory.createProjectArtifact(productArtifact.getGroupId(), productArtifact.getArtifactId(), version);
            version = product.getArtifactRetriever().getLatestStableVersion(warArtifact);
        }
        return version;
    }

    protected final File extractAndProcessHomeDirectory(Product ctx) throws MojoExecutionException {
        File homeDir = this.getHomeDirectory(ctx);
        if (StringUtils.isNotBlank((CharSequence)ctx.getDataHome())) {
            return homeDir;
        }
        File productHomeData = this.getProductHomeData(ctx);
        if (productHomeData != null) {
            if (!homeDir.exists()) {
                this.extractProductHomeData(productHomeData, homeDir, ctx);
                homeDir.mkdir();
                this.processHomeDirectory(ctx, homeDir);
            }
            this.overrideAndPatchHomeDir(homeDir, ctx);
        }
        return homeDir;
    }

    protected void extractProductHomeData(File productHomeData, File homeDir, Product ctx) throws MojoExecutionException {
        File tmpDir = new File(this.getBaseDirectory(ctx), "tmp-resources");
        tmpDir.mkdir();
        try {
            if (productHomeData.isFile()) {
                File tmp = new File(this.getBaseDirectory(ctx), ctx.getId() + "-home");
                ZipUtils.unzip(productHomeData, tmpDir.getPath());
                File rootDir = this.getRootDir(tmpDir, ctx);
                FileUtils.copyDirectory(rootDir, this.getBaseDirectory(ctx), true);
                org.apache.commons.io.FileUtils.moveDirectory((File)tmp, (File)homeDir);
            } else if (productHomeData.isDirectory()) {
                FileUtils.copyDirectory(productHomeData, homeDir, true);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to copy home directory", (Exception)ex);
        }
    }

    protected File getRootDir(File tmpDir, Product ctx) throws MojoExecutionException, IOException {
        File[] topLevelFiles = tmpDir.listFiles();
        if (topLevelFiles.length != 1) {
            Iterable filenames = Iterables.transform(Arrays.asList(topLevelFiles), File::getName);
            throw new MojoExecutionException("Expected a single top-level directory in test resources. Got: " + Joiner.on((String)", ").join(filenames));
        }
        return topLevelFiles[0];
    }

    private final File addArtifactsAndOverrides(Product ctx, File homeDir, File app) throws MojoExecutionException {
        try {
            File appDir;
            if (app.isFile()) {
                appDir = new File(this.getBaseDirectory(ctx), "webapp");
                if (!appDir.exists()) {
                    ZipUtils.unzip(app, appDir.getAbsolutePath());
                }
            } else {
                appDir = app;
            }
            this.addArtifacts(ctx, homeDir, appDir);
            try {
                this.addOverrides(appDir, ctx);
                this.customiseInstance(ctx, homeDir, appDir);
                this.fixJvmArgs(ctx);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to override WAR files using src/test/resources/" + ctx.getInstanceId() + "-app", (Exception)e);
            }
            if (app.isFile()) {
                File warFile = new File(app.getParentFile(), this.getId() + ".war");
                ZipUtils.zipChildren(warFile, appDir);
                return warFile;
            }
            return appDir;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void customiseInstance(Product ctx, File homeDir, File explodedWarDir) throws MojoExecutionException {
    }

    protected void fixJvmArgs(Product ctx) {
        String jvmArgs = JvmArgsFix.defaults().apply(ctx.getJvmArgs());
        ctx.setJvmArgs(jvmArgs);
    }

    private void addArtifacts(Product ctx, File homeDir, File appDir) throws Exception {
        File pluginsDir = this.getUserInstalledPluginsDirectory(ctx, appDir, homeDir);
        File bundledPluginsDir = new File(this.getBaseDirectory(ctx), "bundled-plugins");
        bundledPluginsDir.mkdir();
        File bundledPluginsFile = this.getBundledPluginPath(ctx, appDir);
        if (bundledPluginsFile.exists()) {
            if (bundledPluginsFile.isDirectory()) {
                bundledPluginsDir = bundledPluginsFile;
            } else {
                ZipUtils.unzip(bundledPluginsFile, bundledPluginsDir.getPath());
            }
        }
        if (this.isStaticPlugin()) {
            if (!this.supportsStaticPlugins()) {
                throw new MojoExecutionException("According to your atlassian-plugin.xml file, this plugin is not atlassian-plugins version 2. This app currently only supports atlassian-plugins version 2.");
            }
            pluginsDir = new File(appDir, "WEB-INF/lib");
        }
        if (pluginsDir == null) {
            pluginsDir = bundledPluginsDir;
        }
        ProjectUtils.createDirectory(pluginsDir);
        if (ctx.isInstallPlugin().booleanValue()) {
            this.addThisPluginToDirectory(pluginsDir);
            this.addTestPluginToDirectory(pluginsDir);
        }
        if (!this.isStaticPlugin()) {
            this.addArtifactsToDirectory(this.pluginProvider.provide(ctx), pluginsDir);
        }
        ArrayList<ProductArtifact> artifacts = new ArrayList<ProductArtifact>();
        artifacts.addAll(this.getDefaultLibPlugins());
        artifacts.addAll(ctx.getLibArtifacts());
        this.addArtifactsToDirectory(artifacts, new File(appDir, this.getLibArtifactTargetDir()));
        List<ProductArtifact> applications = this.applicationMapper.provideApplications(ctx);
        this.extractApplicationPlugins(applications, pluginsDir);
        artifacts = new ArrayList();
        artifacts.addAll(this.getDefaultBundledPlugins());
        artifacts.addAll(ctx.getBundledArtifacts());
        artifacts.addAll(this.getAdditionalPlugins(ctx));
        this.addArtifactsToDirectory(artifacts, bundledPluginsDir);
        if (bundledPluginsDir.list().length > 0 && !bundledPluginsFile.isDirectory()) {
            ZipUtils.zipChildren(bundledPluginsFile, bundledPluginsDir);
        }
        if (ctx.getLog4jProperties() != null && this.getLog4jPropertiesPath() != null) {
            org.apache.commons.io.FileUtils.copyFile((File)ctx.getLog4jProperties(), (File)new File(appDir, this.getLog4jPropertiesPath()));
        }
    }

    protected void processHomeDirectory(Product ctx, File snapshotDir) throws MojoExecutionException {
        ConfigFileUtils.replace(this.getConfigFiles(ctx, snapshotDir), this.getReplacements(ctx), false, this.log);
    }

    protected abstract File extractApplication(Product var1, File var2) throws MojoExecutionException;

    protected abstract int startApplication(Product var1, File var2, File var3, Map<String, String> var4) throws MojoExecutionException;

    protected abstract boolean supportsStaticPlugins();

    protected abstract Collection<? extends ProductArtifact> getDefaultBundledPlugins();

    protected abstract Collection<? extends ProductArtifact> getDefaultLibPlugins();

    protected abstract File getBundledPluginPath(Product var1, File var2);

    protected abstract File getUserInstalledPluginsDirectory(Product var1, File var2, File var3);

    protected List<ProductArtifact> getAdditionalPlugins(Product ctx) throws MojoExecutionException {
        return Collections.emptyList();
    }

    protected String getLog4jPropertiesPath() {
        return null;
    }

    protected boolean isStaticPlugin() throws IOException {
        File atlassianPluginXml = new File(this.project.getBasedir(), "src/main/resources/atlassian-plugin.xml");
        if (atlassianPluginXml.exists()) {
            String text = org.apache.commons.io.FileUtils.readFileToString((File)atlassianPluginXml, (Charset)StandardCharsets.UTF_8);
            return !text.contains("pluginsVersion=\"2\"") && !text.contains("plugins-version=\"2\"");
        }
        return false;
    }

    protected final void addThisPluginToDirectory(File targetDir) throws IOException {
        File thisPlugin = this.getPluginFile();
        if (thisPlugin.exists()) {
            Iterator iterateFiles = org.apache.commons.io.FileUtils.iterateFiles((File)targetDir, null, (boolean)false);
            while (iterateFiles.hasNext()) {
                File file = (File)iterateFiles.next();
                if (!FileUtils.doesFileNameMatchArtifact(file.getName(), this.project.getArtifactId())) continue;
                Files.delete(file.toPath());
            }
            org.apache.commons.io.FileUtils.copyFile((File)thisPlugin, (File)new File(targetDir, thisPlugin.getName()));
        } else {
            this.log.info((CharSequence)("No plugin in the current project - " + thisPlugin.getAbsolutePath()));
        }
    }

    protected void addTestPluginToDirectory(File targetDir) throws IOException {
        File testPluginFile = this.getTestPluginFile();
        if (testPluginFile.exists()) {
            org.apache.commons.io.FileUtils.copyFile((File)testPluginFile, (File)new File(targetDir, testPluginFile.getName()));
        }
    }

    protected final File getPluginFile() {
        return new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".jar");
    }

    protected File getTestPluginFile() {
        return new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "-tests.jar");
    }

    protected final void addArtifactsToDirectory(List<ProductArtifact> artifacts, File pluginsDir) throws MojoExecutionException {
        if (!artifacts.isEmpty() && pluginsDir.isDirectory()) {
            org.apache.commons.io.FileUtils.listFiles((File)pluginsDir, null, (boolean)false).stream().filter(File::isFile).filter(file -> this.fileMatchesAnyArtifact((File)file, (Collection<ProductArtifact>)artifacts)).forEach(org.apache.commons.io.FileUtils::deleteQuietly);
            this.goals.copyPlugins(pluginsDir, artifacts);
        }
    }

    private boolean fileMatchesAnyArtifact(File file, Collection<ProductArtifact> artifacts) {
        return artifacts.stream().map(ProductArtifact::getArtifactId).anyMatch(artifactId -> FileUtils.doesFileNameMatchArtifact(file.getName(), artifactId));
    }

    private void extractApplicationPlugins(List<ProductArtifact> products, File bundledPluginsDir) throws IOException {
        for (ProductArtifact product : products) {
            File artifact = this.resolveArtifactForProduct(product).getFile();
            this.log.info((CharSequence)("Extracting " + artifact.getAbsolutePath() + " into " + bundledPluginsDir.getAbsolutePath()));
            ZipUtils.unzip(artifact, bundledPluginsDir.getAbsolutePath(), 0, true, Pattern.compile(".*\\.jar"));
            this.log.debug((CharSequence)"Extracted.");
        }
    }

    private Artifact resolveArtifactForProduct(ProductArtifact product) {
        Artifact artifact = this.artifactFactory.createArtifact(product.getGroupId(), product.getArtifactId(), product.getVersion(), "compile", "obr");
        try {
            MavenSession session = this.context.getExecutionEnvironment().getMavenSession();
            MavenProject project = this.context.getExecutionEnvironment().getMavenProject();
            ArtifactResolver resolver = (ArtifactResolver)session.getContainer().lookup(ArtifactResolver.class);
            resolver.resolve(artifact, project.getRemoteArtifactRepositories(), session.getLocalRepository());
        }
        catch (ArtifactNotFoundException | ArtifactResolutionException | ComponentLookupException e) {
            throw new RuntimeException(e);
        }
        return artifact;
    }

    protected final void addOverrides(File appDir, Product ctx) throws IOException {
        File srcDir = new File(this.project.getBasedir(), "src/test/resources/" + ctx.getInstanceId() + "-app");
        if (srcDir.exists() && appDir.exists()) {
            FileUtils.copyDirectory(srcDir, appDir, true);
        }
    }

    protected final Map<String, String> mergeSystemProperties(Product ctx) {
        HashMap<String, String> properties = new HashMap<String, String>(this.getSystemProperties(ctx));
        properties.put("jarsToSkip", this.getJarsToSkipWhenScanningForTldsAndWebFragments());
        ctx.getSystemPropertyVariables().forEach((key, value) -> properties.put((String)key, (String)value));
        Properties userProperties = this.context.getExecutionEnvironment().getMavenSession().getUserProperties();
        userProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> properties.put((String)key, (String)value)));
        return properties;
    }

    private String getJarsToSkipWhenScanningForTldsAndWebFragments() {
        HashSet<String> jarsToSkip = new HashSet<String>();
        jarsToSkip.add("${tomcat.util.scan.StandardJarScanFilter.jarsToSkip}");
        jarsToSkip.addAll(this.getExtraJarsToSkipWhenScanningForTldsAndWebFragments());
        return String.join((CharSequence)",", jarsToSkip);
    }

    @Nonnull
    protected Collection<String> getExtraJarsToSkipWhenScanningForTldsAndWebFragments() {
        return Collections.emptyList();
    }

    protected abstract Map<String, String> getSystemProperties(Product var1);

    public abstract ProductArtifact getArtifact();

    protected String getLibArtifactTargetDir() {
        return "WEB-INF/lib";
    }
}

