/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.PluginProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class AbstractPluginProvider
implements PluginProvider {
    @Override
    public final List<ProductArtifact> provide(Product product) {
        ArrayList<ProductArtifact> artifacts = new ArrayList<ProductArtifact>();
        artifacts.addAll(product.getPluginArtifacts());
        if (product.getSalVersion() != null) {
            artifacts.addAll(this.getSalArtifacts(product.getSalVersion()));
        }
        if (product.getPdkVersion() != null) {
            artifacts.addAll(this.getPdkInstallArtifacts(product.getPdkVersion()));
        }
        if (product.getRestVersion() != null) {
            artifacts.addAll(this.getRestArtifacts(product.getRestVersion()));
        }
        if (product.getWebConsoleVersion() != null) {
            artifacts.addAll(this.getWebConsoleArtifacts(product.getWebConsoleVersion()));
        }
        if (product.isEnableDevToolbox().booleanValue() && product.getDevToolboxVersion() != null) {
            artifacts.addAll(this.getDevToolboxArtifacts(product.getDevToolboxVersion()));
        }
        if (product.isEnablePde().booleanValue() && product.getPdeVersion() != null) {
            artifacts.addAll(this.getPdeArtifacts(product.getPdeVersion()));
        }
        if (product.isEnableQuickReload().booleanValue() && product.getQuickReloadVersion() != null) {
            artifacts.addAll(this.getQuickLoadArtifacts(product.getQuickReloadVersion()));
        }
        if (product.isEnablePluginViewer().booleanValue() && product.getPluginViewerVersion() != null) {
            artifacts.addAll(this.getPluginViewerArtifacts(product.getPluginViewerVersion()));
        }
        return artifacts;
    }

    protected abstract Collection<ProductArtifact> getSalArtifacts(String var1);

    protected Collection<ProductArtifact> getPdkInstallArtifacts(String pdkInstallVersion) {
        return Collections.singletonList(new ProductArtifact("com.atlassian.pdkinstall", "pdkinstall-plugin", pdkInstallVersion));
    }

    protected Collection<ProductArtifact> getWebConsoleArtifacts(String webConsoleVersion) {
        return Arrays.asList(new ProductArtifact("org.apache.felix", "org.apache.felix.webconsole", webConsoleVersion), new ProductArtifact("org.apache.felix", "org.osgi.compendium", "1.2.0"), new ProductArtifact("com.atlassian.labs.httpservice", "httpservice-bridge", "0.6.2"));
    }

    protected Collection<ProductArtifact> getQuickLoadArtifacts(String version) {
        return Collections.singletonList(new ProductArtifact("com.atlassian.labs.plugins", "quickreload", version));
    }

    protected Collection<ProductArtifact> getPluginViewerArtifacts(String version) {
        return Collections.singletonList(new ProductArtifact("com.atlassian", "plugins-viewer-plugin", version));
    }

    protected Collection<ProductArtifact> getDevToolboxArtifacts(String devToolboxVersion) {
        ArrayList<ProductArtifact> artifacts = new ArrayList<ProductArtifact>();
        artifacts.add(new ProductArtifact("com.atlassian.devrel", "developer-toolbox-plugin", devToolboxVersion));
        artifacts.add(new ProductArtifact("com.atlassian.labs", "rest-api-browser", "3.1.3"));
        return artifacts;
    }

    protected Collection<ProductArtifact> getPdeArtifacts(String pdeVersion) {
        return Collections.singletonList(new ProductArtifact("com.atlassian.plugins", "plugin-data-editor", pdeVersion));
    }

    protected Collection<ProductArtifact> getRestArtifacts(String restVersion) {
        return Collections.singletonList(new ProductArtifact("com.atlassian.plugins.rest", "atlassian-rest-module", restVersion));
    }
}

