/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util.minifier;

import com.atlassian.maven.plugins.amps.util.minifier.GoogleClosureOptionsHandler;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public class GoogleClosureJSMinifier {
    private static CompilerOptions getOptions(Map<String, String> closureOptions, Log log) {
        GoogleClosureOptionsHandler googleClosureOptionsHandler = new GoogleClosureOptionsHandler(log);
        if (closureOptions != null && !closureOptions.isEmpty()) {
            for (String optionName : closureOptions.keySet()) {
                googleClosureOptionsHandler.setOption(optionName, closureOptions.get(optionName));
            }
        }
        return googleClosureOptionsHandler.getCompilerOptions();
    }

    public static CompiledSourceWithSourceMap compile(String code, String sourcePath, Map<String, String> closureOptions, Log log) {
        Compiler compiler = new Compiler();
        CompilerOptions options = GoogleClosureJSMinifier.getOptions(closureOptions, log);
        CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
        options.setSourceMapFormat(SourceMap.Format.V3);
        options.setSourceMapOutputPath("/dummy-file-path");
        SourceFile extern = SourceFile.fromCode((String)"externs.js", (String)"function alert(x) {}");
        SourceFile input = SourceFile.fromCode((String)"input.js", (String)code);
        Result result = compiler.compile(extern, input, options);
        String min = compiler.toSource();
        StringBuilder sourceMapStream = new StringBuilder();
        try {
            result.sourceMap.appendTo((Appendable)sourceMapStream, "/dummy-file-path");
        }
        catch (IOException e) {
            log.warn((CharSequence)("can't create source map for " + sourcePath));
        }
        return new CompiledSourceWithSourceMap(min, sourceMapStream.toString());
    }

    static class CompiledSourceWithSourceMap {
        private final String compiled;
        private final String sourceMap;

        CompiledSourceWithSourceMap(String compiled, String sourceMap) {
            this.compiled = compiled;
            this.sourceMap = sourceMap;
        }

        String getCompiled() {
            return this.compiled;
        }

        String getSourceMap() {
            return this.sourceMap;
        }
    }
}

