/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class ZipUtils {
    private static final int MASK_EXECUTABLE = 64;
    private static final int MODE_EXECUTABLE = 448;

    public static void untargz(File targz, String destDir) throws IOException {
        ZipUtils.untargz(targz, destDir, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void untargz(File targz, String destDir, int leadingPathSegmentsToTrim) throws IOException {
        try (FileInputStream fin = new FileInputStream(targz);
             GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)fin);
             TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzIn);){
            while (true) {
                FileOutputStream fos;
                block50: {
                    TarArchiveEntry entry;
                    if ((entry = tarIn.getNextTarEntry()) == null) {
                        return;
                    }
                    File entryFile = new File(destDir + File.separator + ZipUtils.trimPathSegments(entry.getName(), leadingPathSegmentsToTrim));
                    if (entry.isDirectory()) {
                        entryFile.mkdirs();
                        continue;
                    }
                    if (!entryFile.getParentFile().exists()) {
                        entryFile.getParentFile().mkdirs();
                    }
                    fos = new FileOutputStream(entryFile);
                    Throwable throwable = null;
                    try {
                        IOUtils.copy((InputStream)tarIn, (OutputStream)fos);
                        if ((entry.getMode() & 0x40) != 0) {
                            entryFile.setExecutable(true);
                        }
                        if (fos == null) continue;
                        if (throwable == null) break block50;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    fos.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            fos.close();
                            throw throwable3;
                        }
                    }
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                fos.close();
            }
        }
    }

    public static void unzip(File zipFile, String destDir) throws IOException {
        ZipUtils.unzip(zipFile, destDir, 0);
    }

    public static void unzip(File zipFile, String destDir, int leadingPathSegmentsToTrim) throws IOException {
        ZipUtils.unzip(zipFile, destDir, leadingPathSegmentsToTrim, false, null);
    }

    public static void unzip(File zipFile, String destDir, int leadingPathSegmentsToTrim, boolean flatten, Pattern pattern) throws IOException {
        try (ZipFile zip = new ZipFile(zipFile);){
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry zipEntry = (ZipArchiveEntry)entries.nextElement();
                String name = zipEntry.getName();
                if (pattern != null && !pattern.matcher(name).matches()) continue;
                String zipPath = ZipUtils.trimPathSegments(name, leadingPathSegmentsToTrim);
                if (flatten) {
                    zipPath = ZipUtils.flattenPath(zipPath);
                }
                File file = new File(destDir + "/" + zipPath);
                if (zipEntry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                try (InputStream is = zip.getInputStream(zipEntry);
                     FileOutputStream fos = new FileOutputStream(file);){
                    IOUtils.copy((InputStream)is, (OutputStream)fos);
                    if ((zipEntry.getUnixMode() & 0x40) != 0) {
                        file.setExecutable(true);
                    }
                }
                file.setLastModified(zipEntry.getTime());
            }
        }
    }

    public static int countNestingLevel(File zip) throws IOException {
        try (ZipFile zipFile = new ZipFile(zip);){
            List<String> filenames = ZipUtils.toList(zipFile.getEntries());
            int n = ZipUtils.countNestingLevel(filenames);
            return n;
        }
    }

    static int countNestingLevel(List<String> filenames) {
        String prefix = StringUtils.getCommonPrefix((String[])filenames.toArray(new String[0]));
        if (!prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.lastIndexOf("/") + 1);
        }
        if (filenames.remove(prefix)) {
            return ZipUtils.countNestingLevel(filenames);
        }
        filenames.clear();
        return StringUtils.countMatches((CharSequence)prefix, (CharSequence)"/");
    }

    private static List<String> toList(Enumeration<? extends ZipEntry> entries) {
        ArrayList filenamesList = Lists.newArrayList();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            filenamesList.add(zipEntry.getName());
        }
        return filenamesList;
    }

    public static void zipChildren(File zipFile, File rootDir) throws IOException {
        Path root = rootDir.toPath();
        try (ZipArchiveOutputStream out = new ZipArchiveOutputStream(zipFile);
             Stream<Path> children = Files.walk(root, new FileVisitOption[0]).skip(1L);){
            byte[] buffer = new byte[8192];
            for (Path child : children::iterator) {
                BasicFileAttributes attributes = Files.readAttributes(child, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                if (attributes.isOther() || attributes.isSymbolicLink()) continue;
                String path = root.relativize(child).toString();
                if (SystemUtils.IS_OS_WINDOWS) {
                    path = path.replace('\\', '/');
                }
                if (attributes.isDirectory()) {
                    path = path + "/";
                }
                ZipArchiveEntry entry = new ZipArchiveEntry(path);
                out.putArchiveEntry((ArchiveEntry)entry);
                if (attributes.isRegularFile()) {
                    if (Files.isExecutable(child)) {
                        entry.setUnixMode(448);
                    }
                    try (InputStream content = Files.newInputStream(child, new OpenOption[0]);){
                        ZipUtils.copyViaBuffer(content, (OutputStream)out, buffer);
                    }
                }
                out.closeArchiveEntry();
            }
        }
    }

    public static void zipDir(File zipFile, File srcDir, String prefix) throws IOException {
        try (ZipArchiveOutputStream out = new ZipArchiveOutputStream(zipFile);){
            ZipUtils.addZipPrefixes(srcDir, out, prefix);
            ZipUtils.addZipDir(srcDir, out, prefix);
        }
    }

    private static void addZipPrefixes(File dirObj, ZipArchiveOutputStream out, String prefix) throws IOException {
        String entryPrefix = ZipUtils.ensurePrefixWithSlash(dirObj, prefix);
        String[] prefixes = entryPrefix.split("/");
        String lastPrefix = "";
        for (String p : prefixes) {
            ZipArchiveEntry entry = new ZipArchiveEntry(lastPrefix + p + "/");
            out.putArchiveEntry((ArchiveEntry)entry);
            out.closeArchiveEntry();
            lastPrefix = p + "/";
        }
    }

    private static void addZipDir(File dirObj, ZipArchiveOutputStream out, String prefix) throws IOException {
        File[] files = dirObj.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        byte[] tmpBuf = new byte[8192];
        String entryPrefix = ZipUtils.ensurePrefixWithSlash(dirObj, prefix);
        for (File currentFile : files) {
            String entryName;
            if (currentFile.isDirectory()) {
                entryName = entryPrefix + currentFile.getName() + "/";
                ZipArchiveEntry entry = new ZipArchiveEntry(entryName);
                out.putArchiveEntry((ArchiveEntry)entry);
                out.closeArchiveEntry();
                ZipUtils.addZipDir(currentFile, out, entryName);
                continue;
            }
            if (!currentFile.isFile()) continue;
            entryName = entryPrefix + currentFile.getName();
            try (FileInputStream in = new FileInputStream(currentFile.getAbsolutePath());){
                ZipArchiveEntry entry = new ZipArchiveEntry(entryName);
                out.putArchiveEntry((ArchiveEntry)entry);
                if (currentFile.canExecute()) {
                    entry.setUnixMode(448);
                }
                ZipUtils.copyViaBuffer(in, (OutputStream)out, tmpBuf);
                out.closeArchiveEntry();
            }
        }
    }

    private static void copyViaBuffer(InputStream inputStream, OutputStream outputStream, byte[] buffer) throws IOException {
        int read;
        while ((read = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, read);
        }
    }

    private static String ensurePrefixWithSlash(File rootDir, String prefix) {
        String entryPrefix = prefix;
        if (StringUtils.isNotBlank((CharSequence)entryPrefix) && !entryPrefix.equals("/")) {
            if (entryPrefix.charAt(0) == '/') {
                entryPrefix = entryPrefix.substring(1);
            }
            if (entryPrefix.charAt(entryPrefix.length() - 1) != '/') {
                entryPrefix = entryPrefix + "/";
            }
        } else {
            entryPrefix = rootDir.getName() + "/";
        }
        return entryPrefix;
    }

    private static String trimPathSegments(String zipPath, int trimLeadingPathSegments) {
        int nextSlash;
        int startIndex = 0;
        for (int i = 0; i < trimLeadingPathSegments && (nextSlash = zipPath.indexOf("/", startIndex)) != -1; ++i) {
            startIndex = nextSlash + 1;
        }
        return zipPath.substring(startIndex);
    }

    private static String flattenPath(String zipPath) {
        return zipPath.substring(Math.max(zipPath.lastIndexOf("/"), 0));
    }
}

