/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.jira;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabase;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseType;
import javax.annotation.Nonnull;

public final class JiraDatabaseFactory {
    private static JiraDatabaseFactory instance;

    private JiraDatabaseFactory() {
    }

    public static synchronized JiraDatabaseFactory getJiraDatabaseFactory() {
        if (null == instance) {
            instance = new JiraDatabaseFactory();
        }
        return instance;
    }

    @Nonnull
    public JiraDatabase getJiraDatabase(DataSource dataSource) {
        return JiraDatabaseType.getDatabaseType(dataSource).map(dbType -> dbType.getJiraDatabase(dataSource)).orElseThrow(() -> new IllegalStateException("No DB type for " + dataSource));
    }
}

