/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.atlassian.maven.plugins.amps.util.ZipUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public abstract class AmpsProductHandler
implements ProductHandler {
    protected final MavenGoals goals;
    protected final MavenProject project;
    protected final MavenContext context;
    protected final ArtifactFactory artifactFactory;
    protected final Log log;

    protected AmpsProductHandler(MavenContext context, MavenGoals goals, ArtifactFactory artifactFactory) {
        this.project = context.getProject();
        this.context = context;
        this.goals = goals;
        this.artifactFactory = artifactFactory;
        this.log = context.getLog();
    }

    @Override
    public void createHomeZip(File homeDirectory, File targetZip, Product product) throws MojoExecutionException {
        if (homeDirectory == null || !homeDirectory.exists()) {
            String homePath = "null";
            if (homeDirectory != null) {
                homePath = homeDirectory.getAbsolutePath();
            }
            this.context.getLog().info((CharSequence)("home directory doesn't exist, skipping. [" + homePath + "]"));
            return;
        }
        try {
            File appDir = this.getBaseDirectory(product);
            File tmpDir = new File(appDir, "tmp-resources");
            File homeSnapshot = new File(tmpDir, "generated-home");
            String entryBase = "generated-resources/" + product.getId() + "-home";
            if (homeSnapshot.exists()) {
                org.apache.commons.io.FileUtils.deleteDirectory((File)homeSnapshot);
            }
            homeSnapshot.mkdirs();
            FileUtils.copyDirectory(homeDirectory, homeSnapshot, true);
            this.cleanupProductHomeForZip(product, homeSnapshot);
            ZipUtils.zipDir(targetZip, homeSnapshot, entryBase);
        }
        catch (IOException e) {
            throw new RuntimeException("Error zipping home directory", e);
        }
    }

    @Override
    public void cleanupProductHomeForZip(Product product, File snapshotDir) throws MojoExecutionException, IOException {
        try {
            org.apache.commons.io.FileUtils.deleteDirectory((File)new File(snapshotDir, "plugins"));
            org.apache.commons.io.FileUtils.deleteDirectory((File)new File(snapshotDir, "bundled-plugins"));
            if (this.getTestResourcesArtifact() != null) {
                String originalHomeZip = this.getTestResourcesArtifact().getArtifactId() + ".zip";
                org.apache.commons.io.FileUtils.deleteQuietly((File)new File(snapshotDir, originalHomeZip));
            }
            List<ConfigFileUtils.Replacement> replacements = this.getReplacements(product);
            Collections.sort(replacements);
            List<File> files = this.getConfigFiles(product, snapshotDir);
            ConfigFileUtils.replace(files, replacements, true, this.log);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not delete home/plugins/ and /home/bundled-plugins/", (Exception)ioe);
        }
    }

    public abstract ProductArtifact getTestResourcesArtifact();

    protected File getProductHomeData(Product ctx) throws MojoExecutionException {
        File productHomeZip = null;
        String dataPath = ctx.getDataPath();
        if (StringUtils.isNotBlank((CharSequence)dataPath)) {
            File customHomeZip = new File(dataPath);
            if (customHomeZip.exists()) {
                return customHomeZip;
            }
            throw new MojoExecutionException("Unable to use custom test resources set by <dataPath>. File '" + customHomeZip.getAbsolutePath() + "' does not exist");
        }
        ProductArtifact testResourcesArtifact = this.getTestResourcesArtifact();
        if (productHomeZip == null && testResourcesArtifact != null) {
            if (StringUtils.isBlank((CharSequence)ctx.getDataVersion()) || "RELEASE".equals(ctx.getDataVersion()) || "LATEST".equals(ctx.getDataVersion())) {
                this.log.info((CharSequence)"determining latest stable data version...");
                Artifact dataArtifact = this.artifactFactory.createProjectArtifact(testResourcesArtifact.getGroupId(), testResourcesArtifact.getArtifactId(), ctx.getDataVersion());
                String stableVersion = ctx.getArtifactRetriever().getLatestStableVersion(dataArtifact);
                this.log.info((CharSequence)("using latest stable data version: " + stableVersion));
                testResourcesArtifact.setVersion(stableVersion);
                ctx.setDataVersion(stableVersion);
            }
            ProductArtifact artifact = new ProductArtifact(testResourcesArtifact.getGroupId(), testResourcesArtifact.getArtifactId(), ctx.getDataVersion());
            productHomeZip = this.goals.copyHome(this.getBaseDirectory(ctx), artifact);
        }
        return productHomeZip;
    }

    protected void overrideAndPatchHomeDir(File homeDir, Product ctx) throws MojoExecutionException {
        try {
            File srcDir = new File(this.project.getBasedir(), "src/test/resources/" + ctx.getInstanceId() + "-home");
            if (srcDir.exists() && homeDir.exists()) {
                FileUtils.copyDirectory(srcDir, homeDir, false);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to override files using src/test/resources", (Exception)e);
        }
    }

    @Override
    public List<ConfigFileUtils.Replacement> getReplacements(Product product) {
        ArrayList replacements = Lists.newArrayList();
        String buildDirectory = this.project.getBuild().getDirectory();
        String baseDirectory = this.getBaseDirectory(product).getAbsolutePath();
        String homeDirectory = this.getHomeDirectory(product).getAbsolutePath();
        replacements.add(new ConfigFileUtils.Replacement("%PROJECT_BUILD_DIR%", buildDirectory));
        replacements.add(new ConfigFileUtils.Replacement("%PRODUCT_BASE_DIR%", baseDirectory));
        replacements.add(new ConfigFileUtils.Replacement("%PRODUCT_HOME_DIR%", homeDirectory));
        try {
            replacements.add(new ConfigFileUtils.Replacement("%PROJECT_BUILD_DIR_URL_ENCODED%", URLEncoder.encode(this.propertiesEncode(buildDirectory), "UTF-8")));
            replacements.add(new ConfigFileUtils.Replacement("%PRODUCT_BASE_DIR_URL_ENCODED%", URLEncoder.encode(this.propertiesEncode(baseDirectory), "UTF-8")));
            replacements.add(new ConfigFileUtils.Replacement("%PRODUCT_HOME_DIR_URL_ENCODED%", URLEncoder.encode(this.propertiesEncode(homeDirectory), "UTF-8")));
        }
        catch (UnsupportedEncodingException badJvm) {
            throw new RuntimeException("UTF-8 should be supported on any JVM", badJvm);
        }
        replacements.add(ConfigFileUtils.Replacement.onlyWhenCreatingSnapshot("localhost", product.getServer()));
        try {
            String localHostName = InetAddress.getLocalHost().getHostName();
            replacements.add(new ConfigFileUtils.Replacement("%LOCAL_HOST_NAME%", localHostName));
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return replacements;
    }

    protected String propertiesEncode(String decoded) {
        if (decoded == null) {
            return null;
        }
        String replacement1 = decoded.replaceAll(":", "\\:");
        String replacement2 = replacement1.replaceAll("=", "\\=");
        return replacement2;
    }

    @Override
    public List<File> getConfigFiles(Product product, File snapshotDir) {
        return Lists.newArrayList();
    }

    @Override
    public File getBaseDirectory(Product ctx) {
        return ProjectUtils.createDirectory(new File(this.project.getBuild().getDirectory(), ctx.getInstanceId()));
    }

    @Override
    public File getHomeDirectory(Product ctx) {
        if (StringUtils.isNotBlank((CharSequence)ctx.getDataHome())) {
            return new File(ctx.getDataHome());
        }
        return new File(this.getBaseDirectory(ctx), "home");
    }

    @Override
    public File getSnapshotDirectory(Product product) {
        return this.getHomeDirectory(product);
    }

    @Override
    public String getDefaultContextPath() {
        return "/" + this.getId();
    }

    @Override
    public String getDefaultContainerId() {
        return "tomcat85x";
    }

    protected File createHomeDirectory(Product ctx) {
        return ProjectUtils.createDirectory(this.getHomeDirectory(ctx));
    }
}

