/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class ConfigFileUtils {
    public static void replace(List<File> files, List<Replacement> replacements, boolean inverted, Log log) throws MojoExecutionException {
        for (File file : files) {
            ConfigFileUtils.replace(file, replacements, inverted, log);
        }
    }

    public static void replace(File cfgFile, List<Replacement> replacements, boolean inverted, Log log) throws MojoExecutionException {
        if (!cfgFile.exists()) {
            return;
        }
        try {
            String config = FileUtils.readFileToString((File)cfgFile, (Charset)StandardCharsets.UTF_8);
            if (!inverted) {
                for (Replacement replacement : replacements) {
                    if (!replacement.applyWhenUnzipping()) continue;
                    config = replacement.replace(config);
                }
            } else {
                for (Replacement replacement : replacements) {
                    config = replacement.reverse(config);
                }
            }
            FileUtils.writeStringToFile((File)cfgFile, (String)config, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to replace " + cfgFile, (Exception)ex);
        }
    }

    public static void replaceAll(File cfgFile, String pattern, String replacement) throws MojoExecutionException {
        if (!cfgFile.exists()) {
            return;
        }
        try {
            String config = FileUtils.readFileToString((File)cfgFile, (Charset)StandardCharsets.UTF_8);
            config = config.replaceAll(pattern, replacement);
            FileUtils.writeStringToFile((File)cfgFile, (String)config, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to replace " + cfgFile, (Exception)ex);
        }
    }

    public static void setProperties(File propertiesFile, Map<String, String> newProperties) {
        try (FileInputStream in = new FileInputStream(propertiesFile);){
            Properties props = new Properties();
            props.load(in);
            ((InputStream)in).close();
            newProperties.forEach(props::setProperty);
            try (FileOutputStream out = new FileOutputStream(propertiesFile);){
                props.store(out, "Processed by AMPS");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final class RegexReplacement
    extends Replacement {
        public RegexReplacement(String key, String value) {
            super(key, value, false);
        }

        @Override
        protected String replace(String s, String target, String replacement) {
            return s.replaceAll(target, replacement);
        }
    }

    public static class Replacement
    implements Comparable<Replacement> {
        private final String key;
        private final String value;
        private final boolean applyWhenUnzipping;
        private final boolean reversible;

        public Replacement(String key, String value) {
            this(key, value, true);
        }

        public Replacement(String key, String value, boolean reversible) {
            this(key, value, true, reversible);
        }

        Replacement(String key, String value, boolean applyWhenUnzipping, boolean applyWhenZipping) {
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key must not be null");
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value must not be null");
            this.key = key;
            this.value = value;
            this.applyWhenUnzipping = applyWhenUnzipping;
            this.reversible = applyWhenZipping;
        }

        public static Replacement onlyWhenCreatingSnapshot(String key, String value) {
            return new Replacement(key, value, true, false);
        }

        public final String replace(String s) {
            return this.replace(s, this.key, this.value);
        }

        public final String reverse(String s) {
            return this.reversible ? this.replace(s, this.value, this.key) : s;
        }

        protected String replace(String s, String target, String replacement) {
            return s.replace(target, replacement);
        }

        public final boolean applyWhenUnzipping() {
            return this.applyWhenUnzipping;
        }

        @Override
        public int compareTo(Replacement other) {
            int length1 = this.value.length();
            int length2 = other.value.length();
            return length2 - length1;
        }

        public String toString() {
            String operation = this.applyWhenUnzipping && this.reversible ? " <-> " : (this.applyWhenUnzipping && !this.reversible ? " -> " : (!this.applyWhenUnzipping && this.reversible ? " <- " : " (nop) "));
            return this.key + operation + this.value;
        }
    }
}

