/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerMojo;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductExecution;
import com.atlassian.maven.plugins.amps.TestGroup;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractTestGroupsHandlerMojo
extends AbstractProductHandlerMojo {
    @Parameter(property="testGroup")
    protected String testGroup;
    @Parameter
    private List<TestGroup> testGroups = new ArrayList<TestGroup>();

    protected final List<TestGroup> getTestGroups() {
        return this.testGroups;
    }

    protected final List<ProductExecution> getTestGroupProductExecutions(String testGroupId) throws MojoExecutionException {
        ArrayList<ProductExecution> products = new ArrayList<ProductExecution>();
        int dupCounter = 0;
        HashSet<String> uniqueProductIds = new HashSet<String>();
        Map<String, Product> productContexts = this.getProductContexts();
        for (String instanceId : this.getTestGroupInstanceIds(testGroupId)) {
            Product ctx = productContexts.get(instanceId);
            if (ctx == null) {
                throw new MojoExecutionException("The test group '" + testGroupId + "' refers to a product '" + instanceId + "' that doesn't have an associated <product> configuration.");
            }
            ProductHandler productHandler = this.createProductHandler(ctx.getId());
            if (uniqueProductIds.contains(instanceId)) {
                ctx.setInstanceId(instanceId + "-" + dupCounter++);
            } else {
                uniqueProductIds.add(instanceId);
            }
            products.add(new ProductExecution(ctx, productHandler));
        }
        if (products.size() > 1) {
            this.validatePortConfiguration(products);
        }
        return products;
    }

    private List<String> getTestGroupInstanceIds(String testGroupId) throws MojoExecutionException {
        ArrayList<String> instanceIds = new ArrayList<String>();
        if ("__no_test_group__".equals(testGroupId)) {
            instanceIds.add(this.getProductId());
        }
        for (TestGroup group : this.testGroups) {
            if (!group.getId().equals(testGroupId)) continue;
            instanceIds.addAll(group.getInstanceIds());
        }
        if (ProductHandlerFactory.getIds().contains(testGroupId) && !instanceIds.contains(testGroupId)) {
            instanceIds.add(testGroupId);
        }
        if (instanceIds.isEmpty()) {
            ArrayList<String> validTestGroups = new ArrayList<String>();
            for (TestGroup group : this.testGroups) {
                validTestGroups.add(group.getId());
            }
            this.getLog().warn((CharSequence)("Unknown test group ID: " + testGroupId + " Detected IDs: " + Arrays.toString(validTestGroups.toArray())));
        }
        return instanceIds;
    }

    protected List<ProductExecution> getProductExecutions() throws MojoExecutionException {
        List<ProductExecution> productExecutions;
        if (!StringUtils.isBlank((CharSequence)this.testGroup)) {
            productExecutions = this.getTestGroupProductExecutions(this.testGroup);
        } else if (!StringUtils.isBlank((CharSequence)this.instanceId)) {
            Product ctx = this.getProductContexts().get(this.instanceId);
            if (ctx == null) {
                throw new MojoExecutionException("No product with instance ID '" + this.instanceId + "'");
            }
            ProductHandler product = this.createProductHandler(ctx.getId());
            productExecutions = Collections.singletonList(new ProductExecution(ctx, product));
        } else {
            Product ctx = this.getProductContexts().get(this.getProductId());
            ProductHandler product = this.createProductHandler(ctx.getId());
            productExecutions = Collections.singletonList(new ProductExecution(ctx, product));
        }
        return productExecutions;
    }

    void validatePortConfiguration(List<ProductExecution> executions) throws MojoExecutionException {
        HashMap portsById = new HashMap();
        MutableInt collisions = new MutableInt();
        executions.stream().map(ProductExecution::getProduct).flatMap(AbstractTestGroupsHandlerMojo::streamConfiguredPorts).filter(ConfiguredPort::isStatic).forEach(configured -> {
            ConfiguredPort conflict = (ConfiguredPort)portsById.get(((ConfiguredPort)configured).port);
            if (conflict == null) {
                portsById.put(((ConfiguredPort)configured).port, configured);
            } else {
                this.getLog().error((CharSequence)(((ConfiguredPort)configured).instanceId + ": The configured " + ((ConfiguredPort)configured).type + " port, " + ((ConfiguredPort)configured).port + ", is in use by the " + conflict.type + " port for " + conflict.instanceId));
                collisions.increment();
            }
        });
        int collisionCount = collisions.intValue();
        if (collisionCount != 0) {
            throw new MojoExecutionException(collisionCount + " port conflict" + (collisionCount == 1 ? " was" : "s were") + " detected between the " + executions.size() + " products in the '" + this.testGroup + "' test group");
        }
    }

    private static Stream<ConfiguredPort> streamConfiguredPorts(Product product) {
        String instanceId = product.getInstanceId();
        ConfiguredPort primary = product.isHttps() ? new ConfiguredPort(instanceId, product.getHttpsPort(), "HTTPS") : new ConfiguredPort(instanceId, product.getHttpPort(), "HTTP");
        return Stream.of(primary, new ConfiguredPort(instanceId, product.getAjpPort(), "AJP"), new ConfiguredPort(instanceId, product.getRmiPort(), "RMI"));
    }

    private static class ConfiguredPort {
        private final String instanceId;
        private final int port;
        private final String type;

        ConfiguredPort(String instanceId, int port, String type) {
            this.instanceId = Objects.requireNonNull(instanceId, "instanceId");
            this.port = port;
            this.type = Objects.requireNonNull(type, "type");
        }

        boolean isStatic() {
            return this.port != 0;
        }
    }
}

