/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marshalling.protobuf;

import com.atlassian.annotations.PublicApi;
import com.atlassian.marshalling.api.Marshaller;
import com.atlassian.marshalling.api.MarshallingException;
import com.atlassian.marshalling.api.MarshallingPair;
import com.atlassian.marshalling.api.Unmarshaller;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import java.util.Objects;

@PublicApi
public class ProtobufMarshalling<T extends MessageLite>
implements Marshaller<T>,
Unmarshaller<T> {
    private final Parser<T> parser;

    public ProtobufMarshalling(Parser<T> parser) {
        this.parser = Objects.requireNonNull(parser);
    }

    public byte[] marshallToBytes(T obj) throws MarshallingException {
        return obj.toByteArray();
    }

    public T unmarshallFrom(byte[] bytes) throws MarshallingException {
        try {
            return (T)((MessageLite)this.parser.parseFrom(bytes));
        }
        catch (InvalidProtocolBufferException e) {
            throw new MarshallingException("Unable to parse", (Throwable)e);
        }
    }

    public static <T extends MessageLite> MarshallingPair<T> pair(Parser<T> parser) {
        ProtobufMarshalling<T> sm = new ProtobufMarshalling<T>(parser);
        return new MarshallingPair(sm, sm);
    }
}

