/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marshalling.gson;

import com.atlassian.annotations.PublicApi;
import com.atlassian.marshalling.api.MarshallingPair;
import com.atlassian.marshalling.gson.BaseGsonMarshalling;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

@PublicApi
public class GsonMarshalling<T>
extends BaseGsonMarshalling<T> {
    public GsonMarshalling(Gson gson, Class<T> targetClass) {
        super(gson, TypeToken.get(targetClass));
    }

    public GsonMarshalling(Gson gson, TypeToken<T> typeToken) {
        super(gson, typeToken);
    }

    public static <T> MarshallingPair<T> pair(Gson gson, Class<T> targetClass) {
        GsonMarshalling<T> gm = new GsonMarshalling<T>(gson, targetClass);
        return new MarshallingPair(gm, gm);
    }

    public static <T> MarshallingPair<T> pair(Gson gson, TypeToken<T> typeToken) {
        GsonMarshalling<T> gm = new GsonMarshalling<T>(gson, typeToken);
        return new MarshallingPair(gm, gm);
    }

    public static <T> MarshallingPair<T> pair(TypeToken<T> typeToken) {
        GsonMarshalling<T> gm = new GsonMarshalling<T>(new Gson(), typeToken);
        return new MarshallingPair(gm, gm);
    }

    public static <T> MarshallingPair<T> pair(Class<T> targetClass) {
        GsonMarshalling<T> gm = new GsonMarshalling<T>(new Gson(), targetClass);
        return new MarshallingPair(gm, gm);
    }
}

