/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.markup.renderer.impl;

import com.atlassian.markup.renderer.RenderTransform;
import com.atlassian.markup.renderer.Replacement;
import com.atlassian.markup.renderer.impl.TokenReplacer;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;

public class TransformUtils {
    private static final String TOKEN_CONSTANT = "\u9999";
    private static final Ordering<Replacement> REPLACEMENT_ORDERING = Ordering.from((Comparator)new Comparator<Replacement>(){

        @Override
        public int compare(Replacement o1, Replacement o2) {
            return o1.getStart() - o2.getStart();
        }
    });
    private static final Predicate<Replacement> IS_NOT_IMMEDIATE = new Predicate<Replacement>(){

        public boolean apply(Replacement input) {
            return !input.isImmediate();
        }
    };

    public static CharSequence transform(CharSequence input, Iterable<RenderTransform> transforms) {
        return TransformUtils.replace(input, TransformUtils.getReplacements(transforms));
    }

    public static List<Replacement> getReplacements(Iterable<RenderTransform> transforms) {
        return TransformUtils.removeOverlappingReplacements(REPLACEMENT_ORDERING.sortedCopy(Iterables.concat((Iterable)Iterables.transform(transforms, (Function)new Function<RenderTransform, Iterable<Replacement>>(){

            public Iterable<Replacement> apply(RenderTransform transform) {
                return transform.getReplacements();
            }
        }))));
    }

    public static List<Replacement> removeOverlappingReplacements(List<Replacement> replacements) {
        int i = 0;
        ImmutableList.Builder newReplacements = ImmutableList.builder();
        for (Replacement replacement : replacements) {
            if (replacement.getStart() < i) continue;
            newReplacements.add((Object)replacement);
            i = replacement.getEnd();
        }
        return newReplacements.build();
    }

    public static CharSequence replace(CharSequence input, List<Replacement> replacements) {
        if (replacements.isEmpty()) {
            return input;
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        for (Replacement replacement : replacements) {
            b.append(input.subSequence(i, replacement.getStart()));
            CharSequence value = replacement.getValue();
            b.append(value);
            i = replacement.getEnd();
        }
        b.append(input.subSequence(i, input.length()));
        return b.toString();
    }

    public static TokenReplacer tokenReplace(CharSequence input, Iterable<RenderTransform> transforms) {
        List<Replacement> all = TransformUtils.getReplacements(transforms);
        final ArrayList original = Lists.newArrayList((Iterable)Iterables.filter(all, IS_NOT_IMMEDIATE));
        List replacements = Lists.transform(all, (Function)new Function<Replacement, Replacement>(){

            public Replacement apply(Replacement r) {
                return !r.isImmediate() ? r.setValue((CharSequence)TransformUtils.TOKEN_CONSTANT) : r;
            }
        });
        return new TokenReplacer(TransformUtils.replace(input, replacements), new Function<CharSequence, CharSequence>(){

            public CharSequence apply(CharSequence input) {
                StringTokenizer tokens = new StringTokenizer(((Object)input).toString(), TransformUtils.TOKEN_CONSTANT, true);
                StringBuilder b = new StringBuilder();
                int i = 0;
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    if (token.equals(TransformUtils.TOKEN_CONSTANT)) {
                        if (i >= original.size()) continue;
                        b.append(((Replacement)original.get(i++)).getValue());
                        continue;
                    }
                    b.append(token);
                }
                return b;
            }
        });
    }
}

