/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.markup.renderer;

import com.atlassian.markup.renderer.Replacement;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RenderTransform {
    private final List<Replacement> replacements;

    public RenderTransform(List<Replacement> replacements) {
        this.replacements = ImmutableList.copyOf(replacements);
    }

    public Iterable<Replacement> getReplacements() {
        return this.replacements;
    }

    public RenderTransform immediate() {
        return new RenderTransform(Lists.transform(this.replacements, (Function)new Function<Replacement, Replacement>(){

            public Replacement apply(Replacement input) {
                return input.immediate();
            }
        }));
    }

    public static TransformBuilder builder() {
        return new TransformBuilder();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class TransformBuilder {
        private ImmutableList.Builder<Replacement> replacements = ImmutableList.builder();

        public TransformBuilder add(int start, int end, String value) {
            this.replacements.add((Object)new Replacement(start, end, value));
            return this;
        }

        public RenderTransform build() {
            return new RenderTransform((List<Replacement>)this.replacements.build());
        }
    }
}

