/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.markup.renderer.util;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class LineTransformBufferedReader
extends FilterReader {
    private final BufferedReader buffer;
    private final Function<String, String> transformer;
    private char[] curLine;
    private int curLineIx;

    public LineTransformBufferedReader(Reader buffer, Function<String, String> transformer) {
        this(LineTransformBufferedReader.buffer(buffer), transformer);
    }

    private LineTransformBufferedReader(BufferedReader buffer, Function<String, String> transformer) {
        super(buffer);
        this.buffer = buffer;
        this.transformer = transformer;
    }

    public static LineTransformBufferedReader transform(Reader reader, Function<String, String> transformer) {
        if (reader instanceof LineTransformBufferedReader) {
            return ((LineTransformBufferedReader)reader).fuse(transformer);
        }
        return new LineTransformBufferedReader(reader, transformer);
    }

    public LineTransformBufferedReader fuse(Function<String, String> t2) {
        if (this.curLine == null) {
            return new LineTransformBufferedReader(this.buffer, (Function<String, String>)Functions.compose(t2, this.transformer));
        }
        return new LineTransformBufferedReader(this, t2);
    }

    @Override
    public int read() throws IOException {
        char[] cbuf = new char[1];
        int n = this.read(cbuf, 0, 1);
        return n == -1 ? n : cbuf[0];
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.curLine == null) {
            String line = this.buffer.readLine();
            this.curLine = line == null ? null : ((String)this.transformer.apply((Object)line)).toCharArray();
            this.curLineIx = 0;
        }
        if (this.curLine != null) {
            int num = Math.min(len, Math.min(cbuf.length - off, this.curLine.length - this.curLineIx));
            System.arraycopy(this.curLine, this.curLineIx, cbuf, off, num);
            this.curLineIx += num;
            if (this.curLineIx == this.curLine.length) {
                this.curLine = null;
                if (num < len && off < cbuf.length) {
                    cbuf[off + num] = 10;
                    return num + 1;
                }
            }
            return num;
        }
        return len > 0 ? -1 : 0;
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }

    private static BufferedReader buffer(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }
}

