/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.markup.renderer;

import com.atlassian.markup.renderer.util.UrlUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class RenderContext {
    private final String baseUrl;
    private final Map<String, Object> data;

    public RenderContext(String baseUrl) {
        this(baseUrl, (Map<String, Object>)ImmutableMap.of());
    }

    public RenderContext(String baseUrl, Map<String, Object> data) {
        this.baseUrl = (String)Preconditions.checkNotNull((Object)baseUrl, (Object)"baseUrl");
        this.data = ImmutableMap.copyOf(data);
    }

    @Nonnull
    public String createHostUrl(@Nonnull String path) {
        return UrlUtils.appendUrlPath(this.baseUrl, path);
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public static class Builder {
        private String baseUrl = "";
        private Map<String, Object> data = ImmutableMap.of();

        public RenderContext build() {
            return new RenderContext(this.baseUrl, this.data);
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public void setData(Map<String, Object> data) {
            this.data = data;
        }
    }
}

