package com.atlassian.mail.msgraph.settings.providers;

import com.atlassian.mail.msgraph.service.ExternalMailPuller;
import com.atlassian.mail.msgraph.settings.dto.MailSettingsDTO;
import io.atlassian.fugue.Option;

import static io.atlassian.fugue.Option.none;

public class SimpleAuthMailConnectionSettingsProvider implements MailConnectionSettingsProvider {

    protected final MailSettingsDTO mailSettingsDTO;

    public SimpleAuthMailConnectionSettingsProvider(MailSettingsDTO  mailSettingsDTO) {
        this.mailSettingsDTO = mailSettingsDTO;
    }

    @Override
    public String getUserName() {
        return mailSettingsDTO.getEmailAddress();
    }

    @Override
    public Option<String> getAuthenticationToken() {
        return none();
    }

    @Override
    public String getEmailAddress() {
        return mailSettingsDTO.getEmailAddress();
    }

    @Override
    public long getTimeout() {
        return mailSettingsDTO.getTimeout();
    }


    @Override
    public MailSettingsDTO getMailSettings() {
        return mailSettingsDTO;
    }


    @Override
    public Option<ExternalMailPuller> getHttpMailClient() {
        return none();
    }
}
