package com.atlassian.mail.queue;

import java.util.Date;

import com.atlassian.mail.MailThreader;

public abstract class AbstractMailQueueItem implements MailQueueItem {
    String subject;
    Date dateQueued;
    private int timesSent = 0;
    protected MailThreader mailThreader;

    public AbstractMailQueueItem() {
        this.dateQueued = new Date();
    }

    public AbstractMailQueueItem(String subject) {
        this();
        this.subject = subject;
    }

    public String getSubject() {
        return subject;
    }

    public Date getDateQueued() {
        return dateQueued;
    }

    public int getSendCount() {
        return timesSent;
    }

    public boolean hasError() {
        return (timesSent > 0);
    }

    protected void incrementSendCount() {
        timesSent++;
    }

    public void setMailThreader(MailThreader mailThreader) {
        this.mailThreader = mailThreader;
    }

    public final int compareTo(MailQueueItem o) {
        int priorityComparator = Integer.compare(timesSent, o.getSendCount());
        return priorityComparator == 0 ? dateQueued.compareTo(o.getDateQueued()) : priorityComparator;
    }
}
