package com.atlassian.mail.server;

import com.atlassian.mail.Email;
import com.atlassian.mail.MailConstants;
import com.atlassian.mail.MailException;

import java.io.PrintStream;

public interface SMTPMailServer extends MailServer {
    @Deprecated
    String DEFAULT_SMTP_PORT = MailConstants.DEFAULT_SMTP_PORT;

    String getDefaultFrom();

    void setDefaultFrom(String from);

    String getPrefix();

    void setPrefix(String prefix);

    boolean isSessionServer();

    void setSessionServer(boolean sessionServer);

    String getJndiLocation();

    void setJndiLocation(String jndiLocation);

    public boolean isRemovePrecedence();

    public void setRemovePrecedence(boolean precedence);

    /**
     * Sends the given email.
     * <p>
     * For backward-compatibility, this method will ignore any Message-ID header set in the email parameter, and let
     * JavaMail set its own Message-ID, then populate the header in the email parameter.
     *
     * @param email the Email to send.
     * @throws MailException if the email could not be sent
     * @see #sendWithMessageId(com.atlassian.mail.Email, String)
     */
    void send(Email email) throws MailException;

    /**
     * Sends the given email using the given Message-ID header.
     * <p>
     * Note that this is an advanced method and should only be used if you understand the requirements and restrictions
     * as per <a href="http://www.faqs.org/rfcs/rfc2822.html">RFC 2822</a>;
     * namely that the message-ID must be globally unique and can only contain certain ASCII characters.
     * <p>
     * If the given messageId parameter is null, then we let JavaMail create a Message-ID.
     * Note that (for back-compatibility reasons) the email.getMessageId() is ignored for input, but set with the actual Message-ID used.
     *
     * @param email     the Email to send.
     * @param messageId the desired Message-ID header, or null to let JavaMail create one automatically.
     *                  Do not include the angle-brackets - these will be added automatically.
     * @throws MailException if the email could not be sent
     * @see #send(com.atlassian.mail.Email)
     */
    void sendWithMessageId(Email email, String messageId) throws MailException;

    /**
     * World's stupidest method - it catches all Exceptions and then declares anyway that it throws MailException.
     *
     * @param email an email to send with no exception handling
     * @throws MailException which apparently should never happen
     * @deprecated Use {@link #send(com.atlassian.mail.Email)} instead and deal with the Exception for yourself. Since v2.5.
     */
    @Deprecated
    void quietSend(Email email) throws MailException;

    /**
     * Enable or disable SMTP-level logging.
     *
     * @param debug Turn debugging on or off
     */
    void setDebug(boolean debug);

    /**
     * Whether  logging is enabled.
     */
    boolean getDebug();

    /**
     * Where debug logs currently go to.
     *
     * @return print stream where debug info is logged to
     */
    PrintStream getDebugStream();

    boolean isTlsRequired();

    void setTlsRequired(boolean tlsRequired);

    /**
     * Method for checking in runtime if transport layer caching is enabled (e.g. with a feature flag)
     * Can be overridden by the products' implementation.
     *
     * @return {@code true} if transport layer caching is enabled
     * @since 5.2.0
     */
    default boolean isTransportCachingEnabled() {
        return false;
    }
}