package com.atlassian.mail.server.auth;

import javax.mail.MessagingException;
import javax.mail.Service;
import java.util.Properties;

/**
 * Interface for classes responsible of authenticating connections to mail servers.
 * Sets {@link javax.mail.Session} properties and handle connecting behaviour for {@link Service}
 */
public interface  AuthenticationContext {

    Credentials getCredentials();

    boolean isAuthenticating();

    Properties preparePropertiesForSession(Properties properties);

    void connectService(Service service) throws MessagingException;
}
