package com.atlassian.mail.server.impl;

import com.atlassian.mail.MailException;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.AbstractMailServer;
import com.atlassian.mail.server.ImapMailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.auth.AuthenticationContext;

import javax.mail.Session;
import java.util.Properties;

import static com.atlassian.mail.MailConstants.DEFAULT_IMAP_PORT;
import static com.atlassian.mail.MailConstants.DEFAULT_IMAP_PROTOCOL;
import static com.atlassian.mail.MailConstants.DEFAULT_TIMEOUT;

public class ImapMailServerImpl extends AbstractMailServer implements ImapMailServer {

    private static final long serialVersionUID = -425764558074475005L;

    public ImapMailServerImpl() {
        super();
    }

    public ImapMailServerImpl(Long id, String name, String description, String serverName, String username, String password) {
        this(id, name, description, DEFAULT_IMAP_PROTOCOL, serverName, DEFAULT_IMAP_PORT, username, password, DEFAULT_TIMEOUT);
    }

    public ImapMailServerImpl(Long id, String name, String description, MailProtocol protocol, String serverName, String port, String username, String password) {
        this(id, name, description, protocol, serverName, port, username, password, DEFAULT_TIMEOUT);
    }

    public ImapMailServerImpl(Long id, String name, String description, MailProtocol protocol, String serverName, String port, String username, String password, long timeout) {
        super(id, name, description, protocol, serverName, port, username, password, timeout, null, null);
    }

    public ImapMailServerImpl(Long id, String name, String description, MailProtocol protocol, String serverName, String port, String username, String password, long timeout, String socksHost, String socksPort) {
        super(id, name, description, protocol, serverName, port, username, password, timeout, socksHost, socksPort);
    }

    public ImapMailServerImpl(Long id, String name, String description, String serverName, AuthenticationContext authenticator) {
        this(id, name, description, DEFAULT_IMAP_PROTOCOL, serverName, DEFAULT_IMAP_PORT, authenticator, DEFAULT_TIMEOUT);
    }

    public ImapMailServerImpl(Long id, String name, String description, MailProtocol protocol, String serverName, String port, AuthenticationContext authenticator) {
        this(id, name, description, protocol, serverName, port, authenticator, DEFAULT_TIMEOUT);
    }

    public ImapMailServerImpl(Long id, String name, String description, MailProtocol protocol, String serverName, String port, AuthenticationContext authenticator, long timeout) {
        super(id, name, description, protocol, serverName, port, authenticator, timeout, null, null);
    }

    public ImapMailServerImpl(Long id, String name, String description, MailProtocol protocol, String serverName, String port, AuthenticationContext authenticator, long timeout, String socksHost, String socksPort) {
        super(id, name, description, protocol, serverName, port, authenticator, timeout, socksHost, socksPort);
    }

    public String getType() {
        return MailServerManager.SERVER_TYPES[2];
    }

    public Session getSession() throws MailException {
        final Properties props = loadSystemProperties(getProperties());
        return getSessionFromServerManager(props, getAuthenticator());
    }

}
