package com.atlassian.mail;

/**
 * Represents global settings that control sending of outgoing mail by a {@link com.atlassian.mail.server.MailServer}
 * instance.
 *
 * @since v2.5
 */
public interface Settings {
    /**
     * Key of the system property used by {@link Settings.Default} to determine whether outgoing mail should be sent or
     * not.
     */
    public static String ATLASSIAN_MAIL_SEND_DISABLED_SYSTEM_PROPERTY_KEY = "atlassian.mail.senddisabled";

    /**
     * Whether outgoing mail is disabled or not.
     *
     * @return {@code true} if outgoing should not be sent; otherwise false.
     */
    boolean isSendingDisabled();

    public static class Default implements Settings {
        /**
         * Determines whether outgoing mail should be sent based on the value of the
         * {@link Settings#ATLASSIAN_MAIL_SEND_DISABLED_SYSTEM_PROPERTY_KEY} system property.
         *
         * @return {@code true} if the {@link Settings#ATLASSIAN_MAIL_SEND_DISABLED_SYSTEM_PROPERTY_KEY} is set to
         * {@code true}; otherwise {@code false}.
         */
        @Override
        public boolean isSendingDisabled() {
            return Boolean.getBoolean(ATLASSIAN_MAIL_SEND_DISABLED_SYSTEM_PROPERTY_KEY);
        }
    }
}
