/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.config;

import com.atlassian.mail.Settings;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.util.ClassLoaderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ConfigLoader {
    private static final Logger log = Logger.getLogger(ConfigLoader.class);
    private static final String DEFAULT_CONFIG_FILE = "mail-config.xml";
    private MailServerManager loadedManager;
    private Settings loadedSettings;

    public ConfigLoader(String file) {
        InputStream configurationFileAsStream = ClassLoaderUtils.getResourceAsStream(file, ConfigLoader.class);
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document xmlDoc = db.parse(configurationFileAsStream);
            Element root = xmlDoc.getDocumentElement();
            Element manager = (Element)root.getElementsByTagName("manager").item(0);
            Class aClass = ClassLoaderUtils.loadClass(manager.getAttribute("class"), this.getClass());
            MailServerManager mailServerManager = (MailServerManager)aClass.newInstance();
            HashMap<String, String> params = new HashMap<String, String>();
            NodeList properties = manager.getElementsByTagName("property");
            if (properties.getLength() > 0) {
                for (int i = 0; i < properties.getLength(); ++i) {
                    Element property = (Element)properties.item(i);
                    String name = ConfigLoader.getContainedText(property, "name");
                    String value = ConfigLoader.getContainedText(property, "value");
                    params.put(name, value);
                }
            }
            mailServerManager.init(params);
            this.setLoadedManager(mailServerManager);
            Element settingsNode = (Element)root.getElementsByTagName("settings").item(0);
            if (settingsNode == null) {
                this.setLoadedSettings(new Settings.Default());
            } else {
                Class settingsClass = ClassLoaderUtils.loadClass(settingsNode.getAttribute("class"), ConfigLoader.class);
                Settings settingsInstance = (Settings)settingsClass.newInstance();
                this.setLoadedSettings(settingsInstance);
            }
        }
        catch (Exception e) {
            log.fatal((Object)e, (Throwable)e);
            throw new RuntimeException("Error in mail configuration: " + e.getMessage(), e);
        }
        finally {
            try {
                configurationFileAsStream.close();
            }
            catch (IOException e2) {
                log.error((Object)e2);
            }
        }
    }

    public static MailServerManager getServerManager() {
        return ConfigLoader.getServerManager(DEFAULT_CONFIG_FILE);
    }

    public static MailServerManager getServerManager(String file) {
        ConfigLoader configLoader = new ConfigLoader(file);
        return configLoader.getLoadedManager();
    }

    public static Settings getSettings(String file) {
        ConfigLoader configLoader = new ConfigLoader(file);
        return configLoader.getLoadedSettings();
    }

    public static Settings getSettings() {
        return ConfigLoader.getSettings(DEFAULT_CONFIG_FILE);
    }

    public MailServerManager getLoadedManager() {
        return this.loadedManager;
    }

    public void setLoadedManager(MailServerManager loadedManager) {
        this.loadedManager = loadedManager;
    }

    public void setLoadedSettings(Settings loadedSettings) {
        this.loadedSettings = loadedSettings;
    }

    public Settings getLoadedSettings() {
        return this.loadedSettings;
    }

    private static String getContainedText(Element parent, String childTagName) {
        try {
            Node tag = parent.getElementsByTagName(childTagName).item(0);
            return ((Text)tag.getFirstChild()).getData();
        }
        catch (Exception e) {
            return null;
        }
    }
}

