/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.server;

import com.atlassian.mail.server.auth.AuthenticationContext;
import com.atlassian.mail.server.auth.Credentials;
import com.atlassian.mail.server.auth.UserPasswordCredentials;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Service;
import org.apache.commons.lang.StringUtils;

final class InternalAuthenticationContext
implements AuthenticationContext {
    private String userName = null;
    private String password = null;

    public InternalAuthenticationContext() {
    }

    public InternalAuthenticationContext(String userName, String password) {
        this();
        this.setUserName(userName);
        this.setPassword(password);
    }

    String getUserName() {
        return this.userName;
    }

    String getPassword() {
        return this.password;
    }

    void setPassword(String password) {
        this.password = StringUtils.isNotBlank((String)password) ? password : null;
    }

    void setUserName(String userName) {
        this.userName = StringUtils.isNotBlank((String)userName) ? userName : null;
    }

    @Override
    public void connectService(Service service) throws MessagingException {
        service.connect(this.userName, this.password);
    }

    @Override
    public Credentials getCredentials() {
        return new InternalUserPasswordCredentials();
    }

    @Override
    public boolean isAuthenticating() {
        return this.userName != null;
    }

    @Override
    public Properties preparePropertiesForSession(Properties properties) {
        String protocol = properties.getProperty("mail.transport.protocol");
        properties.put("mail." + protocol + ".auth", Boolean.toString(this.isAuthenticating()));
        return properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalAuthenticationContext that = (InternalAuthenticationContext)o;
        return Objects.equals(this.userName, that.userName) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.userName, this.password);
    }

    private final class InternalUserPasswordCredentials
    implements UserPasswordCredentials {
        private InternalUserPasswordCredentials() {
        }

        @Override
        public String getUserName() {
            return InternalAuthenticationContext.this.userName;
        }

        @Override
        public String getPassword() {
            return InternalAuthenticationContext.this.password;
        }

        @Override
        public Optional<Properties> getProperties() {
            return Optional.ofNullable(null);
        }
    }
}

